/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.acl.AclBinding;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.acl.AclOperation;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.acl.AclPermissionType;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.DescribeAclsResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ApiError;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.resource.PatternType;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.resource.ResourcePattern;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.resource.ResourceType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DescribeAclsResponse
extends AbstractResponse {
    private final DescribeAclsResponseData data;

    public DescribeAclsResponse(DescribeAclsResponseData data) {
        this.data = data;
    }

    public DescribeAclsResponse(Struct struct, short version) {
        this.data = new DescribeAclsResponseData(struct, version);
    }

    @Override
    protected Struct toStruct(short version) {
        this.validate(version);
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public ApiError error() {
        return new ApiError(Errors.forCode(this.data.errorCode()), this.data.errorMessage());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    public List<DescribeAclsResponseData.DescribeAclsResource> acls() {
        return this.data.resources();
    }

    public static DescribeAclsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeAclsResponse(ApiKeys.DESCRIBE_ACLS.responseSchema(version).read(buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    private void validate(short version) {
        boolean unsupported;
        if (version == 0 && (unsupported = this.acls().stream().anyMatch(acl -> acl.patternType() != PatternType.LITERAL.code()))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        for (DescribeAclsResponseData.DescribeAclsResource resource : this.acls()) {
            if (resource.patternType() == PatternType.UNKNOWN.code() || resource.resourceType() == ResourceType.UNKNOWN.code()) {
                throw new IllegalArgumentException("Contain UNKNOWN elements");
            }
            for (DescribeAclsResponseData.AclDescription acl2 : resource.acls()) {
                if (acl2.operation() != AclOperation.UNKNOWN.code() && acl2.permissionType() != AclPermissionType.UNKNOWN.code()) continue;
                throw new IllegalArgumentException("Contain UNKNOWN elements");
            }
        }
    }

    private static Stream<AclBinding> aclBindings(DescribeAclsResponseData.DescribeAclsResource resource) {
        return resource.acls().stream().map(acl -> {
            ResourcePattern pattern = new ResourcePattern(ResourceType.fromCode(resource.resourceType()), resource.resourceName(), PatternType.fromCode(resource.patternType()));
            AccessControlEntry entry = new AccessControlEntry(acl.principal(), acl.host(), AclOperation.fromCode(acl.operation()), AclPermissionType.fromCode(acl.permissionType()));
            return new AclBinding(pattern, entry);
        });
    }

    public static List<AclBinding> aclBindings(List<DescribeAclsResponseData.DescribeAclsResource> resources) {
        return resources.stream().flatMap(DescribeAclsResponse::aclBindings).collect(Collectors.toList());
    }

    public static List<DescribeAclsResponseData.DescribeAclsResource> aclsResources(Collection<AclBinding> acls) {
        HashMap<ResourcePattern, List> patternToEntries = new HashMap<ResourcePattern, List>();
        for (AclBinding acl : acls) {
            patternToEntries.computeIfAbsent(acl.pattern(), v -> new ArrayList()).add(acl.entry());
        }
        ArrayList<DescribeAclsResponseData.DescribeAclsResource> resources = new ArrayList<DescribeAclsResponseData.DescribeAclsResource>(patternToEntries.size());
        for (Map.Entry entry : patternToEntries.entrySet()) {
            ResourcePattern key = (ResourcePattern)entry.getKey();
            ArrayList<DescribeAclsResponseData.AclDescription> aclDescriptions = new ArrayList<DescribeAclsResponseData.AclDescription>();
            for (AccessControlEntry ace : (List)entry.getValue()) {
                DescribeAclsResponseData.AclDescription ad = new DescribeAclsResponseData.AclDescription().setHost(ace.host()).setOperation(ace.operation().code()).setPermissionType(ace.permissionType().code()).setPrincipal(ace.principal());
                aclDescriptions.add(ad);
            }
            DescribeAclsResponseData.DescribeAclsResource dar = new DescribeAclsResponseData.DescribeAclsResource().setResourceName(key.name()).setPatternType(key.patternType().code()).setResourceType(key.resourceType().code()).setAcls(aclDescriptions);
            resources.add(dar);
        }
        return resources;
    }
}

