/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.quota.ClientQuotaFilter;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import java.util.ArrayList;

public class DescribeClientQuotasRequest
extends AbstractRequest {
    private static final byte MATCH_TYPE_EXACT = 0;
    private static final byte MATCH_TYPE_DEFAULT = 1;
    private static final byte MATCH_TYPE_SPECIFIED = 2;
    private final DescribeClientQuotasRequestData data;

    public DescribeClientQuotasRequest(DescribeClientQuotasRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CLIENT_QUOTAS, version);
        this.data = data;
    }

    public DescribeClientQuotasRequest(Struct struct, short version) {
        super(ApiKeys.DESCRIBE_CLIENT_QUOTAS, version);
        this.data = new DescribeClientQuotasRequestData(struct, version);
    }

    public ClientQuotaFilter filter() {
        ArrayList<ClientQuotaFilterComponent> components = new ArrayList<ClientQuotaFilterComponent>(this.data.components().size());
        for (DescribeClientQuotasRequestData.ComponentData componentData : this.data.components()) {
            ClientQuotaFilterComponent component;
            switch (componentData.matchType()) {
                case 0: {
                    component = ClientQuotaFilterComponent.ofEntity(componentData.entityType(), componentData.match());
                    break;
                }
                case 1: {
                    component = ClientQuotaFilterComponent.ofDefaultEntity(componentData.entityType());
                    break;
                }
                case 2: {
                    component = ClientQuotaFilterComponent.ofEntityType(componentData.entityType());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected match type: " + componentData.matchType());
                }
            }
            components.add(component);
        }
        if (this.data.strict()) {
            return ClientQuotaFilter.containsOnly(components);
        }
        return ClientQuotaFilter.contains(components);
    }

    @Override
    public DescribeClientQuotasResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeClientQuotasResponse(throttleTimeMs, e);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeClientQuotasRequest> {
        private final DescribeClientQuotasRequestData data;

        public Builder(ClientQuotaFilter filter) {
            super(ApiKeys.DESCRIBE_CLIENT_QUOTAS);
            ArrayList<DescribeClientQuotasRequestData.ComponentData> componentData = new ArrayList<DescribeClientQuotasRequestData.ComponentData>(filter.components().size());
            for (ClientQuotaFilterComponent component : filter.components()) {
                DescribeClientQuotasRequestData.ComponentData fd = new DescribeClientQuotasRequestData.ComponentData().setEntityType(component.entityType());
                if (component.match() == null) {
                    fd.setMatchType((byte)2);
                    fd.setMatch(null);
                } else if (component.match().isPresent()) {
                    fd.setMatchType((byte)0);
                    fd.setMatch(component.match().get());
                } else {
                    fd.setMatchType((byte)1);
                    fd.setMatch(null);
                }
                componentData.add(fd);
            }
            this.data = new DescribeClientQuotasRequestData().setComponents(componentData).setStrict(filter.strict());
        }

        @Override
        public DescribeClientQuotasRequest build(short version) {
            return new DescribeClientQuotasRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

