/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.DescribeGroupsResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.Utils;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DescribeGroupsResponse
extends AbstractResponse {
    public static final int AUTHORIZED_OPERATIONS_OMITTED = Integer.MIN_VALUE;
    private DescribeGroupsResponseData data;
    public static final String UNKNOWN_STATE = "";
    public static final String UNKNOWN_PROTOCOL_TYPE = "";
    public static final String UNKNOWN_PROTOCOL = "";

    public DescribeGroupsResponse(DescribeGroupsResponseData data) {
        this.data = data;
    }

    public DescribeGroupsResponse(Struct struct, short version) {
        this.data = new DescribeGroupsResponseData(struct, version);
    }

    public static DescribeGroupsResponseData.DescribedGroupMember groupMember(String memberId, String groupInstanceId, String clientId, String clientHost, byte[] assignment, byte[] metadata) {
        return new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(memberId).setGroupInstanceId(groupInstanceId).setClientId(clientId).setClientHost(clientHost).setMemberAssignment(assignment).setMemberMetadata(metadata);
    }

    public static DescribeGroupsResponseData.DescribedGroup groupMetadata(String groupId, Errors error, String state, String protocolType, String protocol, List<DescribeGroupsResponseData.DescribedGroupMember> members, Set<Byte> authorizedOperations) {
        DescribeGroupsResponseData.DescribedGroup groupMetadata = new DescribeGroupsResponseData.DescribedGroup();
        groupMetadata.setGroupId(groupId).setErrorCode(error.code()).setGroupState(state).setProtocolType(protocolType).setProtocolData(protocol).setMembers(members).setAuthorizedOperations(Utils.to32BitField(authorizedOperations));
        return groupMetadata;
    }

    public static DescribeGroupsResponseData.DescribedGroup groupMetadata(String groupId, Errors error, String state, String protocolType, String protocol, List<DescribeGroupsResponseData.DescribedGroupMember> members, int authorizedOperations) {
        DescribeGroupsResponseData.DescribedGroup groupMetadata = new DescribeGroupsResponseData.DescribedGroup();
        groupMetadata.setGroupId(groupId).setErrorCode(error.code()).setGroupState(state).setProtocolType(protocolType).setProtocolData(protocol).setMembers(members).setAuthorizedOperations(authorizedOperations);
        return groupMetadata;
    }

    public DescribeGroupsResponseData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.groups().forEach(describedGroup -> this.updateErrorCounts(errorCounts, Errors.forCode(describedGroup.errorCode())));
        return errorCounts;
    }

    public static DescribeGroupsResponseData.DescribedGroup forError(String groupId, Errors error) {
        return DescribeGroupsResponse.groupMetadata(groupId, error, "", "", "", Collections.emptyList(), Integer.MIN_VALUE);
    }

    public static DescribeGroupsResponse fromError(int throttleTimeMs, Errors error, List<String> groupIds) {
        DescribeGroupsResponseData describeGroupsResponseData = new DescribeGroupsResponseData();
        describeGroupsResponseData.setThrottleTimeMs(throttleTimeMs);
        for (String groupId : groupIds) {
            describeGroupsResponseData.groups().add(DescribeGroupsResponse.forError(groupId, error));
        }
        return new DescribeGroupsResponse(describeGroupsResponseData);
    }

    public static DescribeGroupsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeGroupsResponse(ApiKeys.DESCRIBE_GROUPS.responseSchema(version).read(buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }
}

