/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.DescribeLogDirsResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class DescribeLogDirsResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET_LAG = -1L;
    private final DescribeLogDirsResponseData data;

    public DescribeLogDirsResponse(Struct struct, short version) {
        this.data = new DescribeLogDirsResponseData(struct, version);
    }

    public DescribeLogDirsResponse(DescribeLogDirsResponseData data) {
        this.data = data;
    }

    public DescribeLogDirsResponseData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result -> this.updateErrorCounts(errorCounts, Errors.forCode(result.errorCode())));
        return errorCounts;
    }

    public Map<String, LogDirInfo> logDirInfos() {
        HashMap<String, LogDirInfo> result = new HashMap<String, LogDirInfo>(this.data.results().size());
        for (DescribeLogDirsResponseData.DescribeLogDirsResult logDirResult : this.data.results()) {
            HashMap<TopicPartition, ReplicaInfo> replicaInfoMap = new HashMap<TopicPartition, ReplicaInfo>();
            for (DescribeLogDirsResponseData.DescribeLogDirsTopic t : logDirResult.topics()) {
                for (DescribeLogDirsResponseData.DescribeLogDirsPartition p : t.partitions()) {
                    replicaInfoMap.put(new TopicPartition(t.name(), p.partitionIndex()), new ReplicaInfo(p.partitionSize(), p.offsetLag(), p.isFutureKey()));
                }
            }
            result.put(logDirResult.logDir(), new LogDirInfo(Errors.forCode(logDirResult.errorCode()), replicaInfoMap));
        }
        return result;
    }

    public static DescribeLogDirsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeLogDirsResponse(ApiKeys.DESCRIBE_LOG_DIRS.responseSchema(version).read(buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    public static class ReplicaInfo {
        public final long size;
        public final long offsetLag;
        public final boolean isFuture;

        public ReplicaInfo(long size, long offsetLag, boolean isFuture) {
            this.size = size;
            this.offsetLag = offsetLag;
            this.isFuture = isFuture;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(size=").append(this.size).append(", offsetLag=").append(this.offsetLag).append(", isFuture=").append(this.isFuture).append(")");
            return builder.toString();
        }
    }

    public static class LogDirInfo {
        public final Errors error;
        public final Map<TopicPartition, ReplicaInfo> replicaInfos;

        public LogDirInfo(Errors error, Map<TopicPartition, ReplicaInfo> replicaInfos) {
            this.error = error;
            this.replicaInfos = replicaInfos;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(error=").append((Object)this.error).append(", replicas=").append(this.replicaInfos).append(")");
            return builder.toString();
        }
    }
}

