/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.Node;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.FindCoordinatorResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Map;

public class FindCoordinatorResponse
extends AbstractResponse {
    private final FindCoordinatorResponseData data;

    public FindCoordinatorResponse(FindCoordinatorResponseData data) {
        this.data = data;
    }

    public FindCoordinatorResponse(Struct struct, short version) {
        this.data = new FindCoordinatorResponseData(struct, version);
    }

    public FindCoordinatorResponseData data() {
        return this.data;
    }

    public Node node() {
        return new Node(this.data.nodeId(), this.data.host(), this.data.port());
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static FindCoordinatorResponse parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorResponse(ApiKeys.FIND_COORDINATOR.responseSchema(version).read(buffer), version);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public static FindCoordinatorResponse prepareResponse(Errors error, Node node) {
        FindCoordinatorResponseData data = new FindCoordinatorResponseData();
        data.setErrorCode(error.code()).setErrorMessage(error.message()).setNodeId(node.id()).setHost(node.host()).setPort(node.port());
        return new FindCoordinatorResponse(data);
    }
}

