/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.LeaderAndIsrResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LeaderAndIsrResponse
extends AbstractResponse {
    private final LeaderAndIsrResponseData data;

    public LeaderAndIsrResponse(LeaderAndIsrResponseData data) {
        this.data = data;
    }

    public LeaderAndIsrResponse(Struct struct, short version) {
        this.data = new LeaderAndIsrResponseData(struct, version);
    }

    public List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions() {
        return this.data.partitionErrors();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        Errors error = this.error();
        if (error != Errors.NONE) {
            return Collections.singletonMap(error, this.data.partitionErrors().size());
        }
        return this.errorCounts(this.data.partitionErrors().stream().map(l -> Errors.forCode(l.errorCode())));
    }

    public static LeaderAndIsrResponse parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrResponse(ApiKeys.LEADER_AND_ISR.parseResponse(version, buffer), version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

