/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationResult;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class OAuthBearerValidationUtils {
    public static OAuthBearerValidationResult validateClaimForExistenceAndType(OAuthBearerUnsecuredJws jwt, boolean required, String claimName, Class<?> ... allowedTypes) {
        Object rawClaim = Objects.requireNonNull(jwt).rawClaim(Objects.requireNonNull(claimName));
        if (rawClaim == null) {
            return required ? OAuthBearerValidationResult.newFailure(String.format("Required claim missing: %s", claimName)) : OAuthBearerValidationResult.newSuccess();
        }
        for (Class<?> allowedType : allowedTypes) {
            if (allowedType == null || !allowedType.isAssignableFrom(rawClaim.getClass())) continue;
            return OAuthBearerValidationResult.newSuccess();
        }
        return OAuthBearerValidationResult.newFailure(String.format("The %s claim had the incorrect type: %s", claimName, rawClaim.getClass().getSimpleName()));
    }

    public static OAuthBearerValidationResult validateIssuedAt(OAuthBearerUnsecuredJws jwt, boolean required, long whenCheckTimeMs, int allowableClockSkewMs) throws OAuthBearerConfigException {
        boolean exists;
        Number value;
        try {
            value = Objects.requireNonNull(jwt).issuedAt();
        }
        catch (OAuthBearerIllegalTokenException e) {
            return e.reason();
        }
        boolean bl = exists = value != null;
        if (!exists) {
            return OAuthBearerValidationUtils.doesNotExistResult(required, "iat");
        }
        double doubleValue = value.doubleValue();
        return 1000.0 * doubleValue > (double)(whenCheckTimeMs + (long)OAuthBearerValidationUtils.confirmNonNegative(allowableClockSkewMs)) ? OAuthBearerValidationResult.newFailure(String.format("The Issued At value (%f seconds) was after the indicated time (%d ms) plus allowable clock skew (%d ms)", doubleValue, whenCheckTimeMs, allowableClockSkewMs)) : OAuthBearerValidationResult.newSuccess();
    }

    public static OAuthBearerValidationResult validateExpirationTime(OAuthBearerUnsecuredJws jwt, long whenCheckTimeMs, int allowableClockSkewMs) throws OAuthBearerConfigException {
        boolean exists;
        Number value;
        try {
            value = Objects.requireNonNull(jwt).expirationTime();
        }
        catch (OAuthBearerIllegalTokenException e) {
            return e.reason();
        }
        boolean bl = exists = value != null;
        if (!exists) {
            return OAuthBearerValidationUtils.doesNotExistResult(true, "exp");
        }
        double doubleValue = value.doubleValue();
        return (double)(whenCheckTimeMs - (long)OAuthBearerValidationUtils.confirmNonNegative(allowableClockSkewMs)) >= 1000.0 * doubleValue ? OAuthBearerValidationResult.newFailure(String.format("The indicated time (%d ms) minus allowable clock skew (%d ms) was on or after the Expiration Time value (%f seconds)", whenCheckTimeMs, allowableClockSkewMs, doubleValue)) : OAuthBearerValidationResult.newSuccess();
    }

    public static OAuthBearerValidationResult validateTimeConsistency(OAuthBearerUnsecuredJws jwt) {
        Number expirationTime;
        Number issuedAt;
        try {
            issuedAt = Objects.requireNonNull(jwt).issuedAt();
            expirationTime = jwt.expirationTime();
        }
        catch (OAuthBearerIllegalTokenException e) {
            return e.reason();
        }
        if (expirationTime != null && issuedAt != null && expirationTime.doubleValue() <= issuedAt.doubleValue()) {
            return OAuthBearerValidationResult.newFailure(String.format("The Expiration Time time (%f seconds) was not after the Issued At time (%f seconds)", expirationTime.doubleValue(), issuedAt.doubleValue()));
        }
        return OAuthBearerValidationResult.newSuccess();
    }

    public static OAuthBearerValidationResult validateScope(OAuthBearerToken token, List<String> requiredScope) {
        Set<String> tokenScope = token.scope();
        if (requiredScope == null || requiredScope.isEmpty()) {
            return OAuthBearerValidationResult.newSuccess();
        }
        for (String requiredScopeElement : requiredScope) {
            if (tokenScope.contains(requiredScopeElement)) continue;
            return OAuthBearerValidationResult.newFailure(String.format("The provided scope (%s) was mising a required scope (%s).  All required scope elements: %s", String.valueOf(tokenScope), requiredScopeElement, requiredScope.toString()), requiredScope.toString(), null);
        }
        return OAuthBearerValidationResult.newSuccess();
    }

    private static int confirmNonNegative(int allowableClockSkewMs) throws OAuthBearerConfigException {
        if (allowableClockSkewMs < 0) {
            throw new OAuthBearerConfigException(String.format("Allowable clock skew must not be negative: %d", allowableClockSkewMs));
        }
        return allowableClockSkewMs;
    }

    private static OAuthBearerValidationResult doesNotExistResult(boolean required, String claimName) {
        return required ? OAuthBearerValidationResult.newFailure(String.format("Required claim missing: %s", claimName)) : OAuthBearerValidationResult.newSuccess();
    }

    private OAuthBearerValidationUtils() {
    }
}

