/*
 * Decompiled with CFR 0.152.
 */
package cz.scholz.aliaskeymanager;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class AliasKeyManager
extends X509ExtendedKeyManager {
    X509ExtendedKeyManager original;
    String alias;

    public AliasKeyManager(String alias, X509ExtendedKeyManager original) {
        if (alias == null) {
            throw new IllegalArgumentException("The alias cannot be null.");
        }
        if (original == null) {
            throw new IllegalArgumentException("The original key manager cannot be null.");
        }
        this.alias = alias;
        this.original = original;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return new String[]{this.alias};
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.alias;
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.original.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.original.chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.original.getCertificateChain(s);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.original.getPrivateKey(s);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.alias;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.original.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

