/*
 * Decompiled with CFR 0.152.
 */
package cz.scholz.aliaskeymanager;

import cz.scholz.aliaskeymanager.AliasKeyManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;

public class AliasKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    protected final String algorithm = "aliaskm";
    protected String baseAlgorithm;
    protected KeyManagerFactory originalFactory;
    protected String alias;

    @Override
    protected void engineInit(KeyStore keyStore, char[] chars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (KeyManagerFactory.getDefaultAlgorithm().equals("aliaskm")) {
            this.baseAlgorithm = System.getProperty("cz.scholz.aliaskeymanager.basealgorithm");
            if ("aliaskm".equals(this.baseAlgorithm)) {
                throw new NoSuchAlgorithmException("Base algorithm has to be different from aliaskm");
            }
        } else {
            this.baseAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (this.baseAlgorithm == null) {
            throw new NoSuchAlgorithmException("No base algorithm has been identified");
        }
        this.originalFactory = KeyManagerFactory.getInstance(this.baseAlgorithm);
        this.originalFactory.init(keyStore, chars);
        this.alias = this.determineAlias(keyStore, chars);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        return this.wrapKeyManagers(this.originalFactory.getKeyManagers());
    }

    protected KeyManager[] wrapKeyManagers(KeyManager[] originalKeyManagers) {
        ArrayList<AliasKeyManager> wrapped = new ArrayList<AliasKeyManager>();
        for (int i = 0; i < originalKeyManagers.length; ++i) {
            if (!(originalKeyManagers[i] instanceof X509ExtendedKeyManager)) continue;
            AliasKeyManager wrap = new AliasKeyManager(this.alias, (X509ExtendedKeyManager)originalKeyManagers[i]);
            wrapped.add(wrap);
        }
        return wrapped.toArray(new KeyManager[0]);
    }

    protected String determineAlias(KeyStore keyStore, char[] chars) throws KeyStoreException {
        String alias = System.getProperty("cz.scholz.aliaskeymanager.alias");
        if (alias != null) {
            if (keyStore.containsAlias(alias)) {
                return alias;
            }
            throw new KeyStoreException("Alias " + alias + " does not exist in the keystore");
        }
        Enumeration<String> aliases = keyStore.aliases();
        if (aliases.hasMoreElements()) {
            return aliases.nextElement();
        }
        throw new KeyStoreException("No aliases found in the keystore");
    }
}

