/*
 * Decompiled with CFR 0.152.
 */
package cz.scholz.aliaskeymanager;

import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;

public class AliasProvider
extends Provider {
    private static final String DEFAULT_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    private static final String ALGORITHM = "aliaskm";
    private static final Double VERSION = 1.0;
    private static final String INFO = "Alias Security provider provides the Key MAnager which selects the client key for authtentication based on the alias";
    private final String KM_SERVICE = "KeyManagerFactory.aliaskm";
    private final String KM_SPI = "cz.scholz.aliaskeymanager.AliasKeyManagerFactorySpi";

    public AliasProvider() {
        super(ALGORITHM, VERSION, INFO);
        this.put("KeyManagerFactory.aliaskm", "cz.scholz.aliaskeymanager.AliasKeyManagerFactorySpi");
    }

    public static void enable() {
        if (Security.getProvider(ALGORITHM) == null) {
            AliasProvider aliasProvider = new AliasProvider();
            Security.addProvider(aliasProvider);
        }
    }

    public static void disable() {
        if (ALGORITHM.equals(Security.getProperty("ssl.KeyManagerFactory.algorithm"))) {
            Security.setProperty("ssl.KeyManagerFactory.algorithm", DEFAULT_ALGORITHM);
        }
        if (Security.getProvider(ALGORITHM) != null) {
            Security.removeProvider(ALGORITHM);
        }
    }

    public static void setAsDefault() {
        AliasProvider.enable();
        System.setProperty("cz.scholz.aliaskeymanager.basealgorithm", DEFAULT_ALGORITHM);
        Security.setProperty("ssl.KeyManagerFactory.algorithm", ALGORITHM);
    }

    public static void unsetAsDefault() {
        Security.setProperty("ssl.KeyManagerFactory.algorithm", DEFAULT_ALGORITHM);
    }

    public static void setAlias(String alias) {
        System.setProperty("cz.scholz.aliaskeymanager.alias", alias);
    }

    public static void unSetAlias() {
        System.clearProperty("cz.scholz.aliaskeymanager.alias");
    }
}

