/*
 * Decompiled with CFR 0.152.
 */
package cz.tvrzna.dbrunk;

import cz.tvrzna.dbrunk.Database;
import cz.tvrzna.dbrunk.DbConcurrentMap;
import cz.tvrzna.dbrunk.annotations.Entity;
import cz.tvrzna.dbrunk.annotations.Id;
import cz.tvrzna.dbrunk.databases.FileDatabase;
import cz.tvrzna.dbrunk.databases.GZipFileDatabase;
import cz.tvrzna.dbrunk.databases.MemoryDatabase;
import cz.tvrzna.dbrunk.exceptions.DbrunkDbException;
import cz.tvrzna.dbrunk.exceptions.DbrunkInitException;
import cz.tvrzna.dbrunk.repositories.AbstractEntity;
import cz.tvrzna.dbrunk.repositories.ResultWrapper;
import cz.tvrzna.dbrunk.utils.DbrunkType;
import cz.tvrzna.dbrunk.utils.Reflections;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class DbrunkService {
    private static final int MIN_COUNTER_VALUE = 0;
    private static final int MAX_COUNTER_VALUE = 9999;
    private static int rotateCounter = 0;
    private static DbrunkService instance;
    private Semaphore semaphore = new Semaphore(1, true);
    private Database db;
    private boolean autocommit = true;

    public static DbrunkService getInstance() {
        if (instance == null) {
            instance = new DbrunkService();
        }
        return instance;
    }

    public void init(DbrunkType dbType, String filePath) throws DbrunkInitException {
        if (this.db == null) {
            try {
                switch (dbType) {
                    case MEMORY: {
                        this.db = new MemoryDatabase();
                        break;
                    }
                    case GZIP: {
                        this.db = new GZipFileDatabase(filePath);
                        break;
                    }
                    default: {
                        this.db = new FileDatabase(filePath);
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new DbrunkInitException("Could not initialize database", e);
            }
        } else {
            throw new DbrunkInitException("Database is already initialized", null);
        }
    }

    public <T extends AbstractEntity> T save(Class<T> clazz, T entity) {
        ResultWrapper result = new ResultWrapper();
        this.dbOperation(clazz, map -> {
            AbstractEntity resultEntity = entity;
            if (this.getEntityId(resultEntity) == null) {
                this.setEntityId(resultEntity, this.generateId());
            }
            map.put(this.getEntityId(resultEntity), resultEntity);
            result.setValue(resultEntity);
        }, false);
        return result.getValue();
    }

    public <T extends AbstractEntity> T find(Class<T> clazz, Long id) {
        ResultWrapper result = new ResultWrapper();
        this.dbOperation(clazz, map -> result.setValue((AbstractEntity)map.get(id)), true);
        return result.getValue();
    }

    public <T extends AbstractEntity> List<T> findAll(Class<T> clazz) {
        ArrayList result = new ArrayList();
        this.dbOperation(clazz, map -> result.addAll(map.values()), true);
        return result;
    }

    public <T extends AbstractEntity> void remove(Class<T> clazz, Long id) {
        this.dbOperation(clazz, map -> map.remove(id), false);
    }

    public <T extends AbstractEntity> void remove(Class<T> clazz, T entity) {
        this.dbOperation(clazz, map -> map.remove(this.getEntityId(entity)), false);
    }

    public <T extends AbstractEntity> void removeAll(Class<T> clazz) {
        this.dbOperation(clazz, map -> map.clear(), false);
    }

    public void commit() {
        try {
            this.db.commit();
        }
        catch (Exception e) {
            throw new DbrunkDbException("Could not commit to database.", e);
        }
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    private <T extends AbstractEntity> void dbOperation(Class<T> clazz, Consumer<DbConcurrentMap<T>> function, boolean readOnly) throws DbrunkDbException {
        block8: {
            try {
                if (!this.semaphore.tryAcquire(1L, TimeUnit.SECONDS)) break block8;
                try {
                    String tableName = clazz.getAnnotation(Entity.class).value();
                    DbConcurrentMap<T> map = this.db.createOrOpen(tableName, clazz);
                    function.accept(map);
                    if (this.autocommit && !readOnly) {
                        this.db.commit();
                    }
                }
                catch (Exception e) {
                    throw new DbrunkDbException("Could not perform DB operation", e);
                }
                finally {
                    this.semaphore.release();
                }
            }
            catch (Exception e) {
                throw new DbrunkDbException("Could not acquire database.", e);
            }
        }
    }

    private <T extends AbstractEntity> Long getEntityId(T object) {
        Field[] fields = Reflections.findAnnotatedFields(object, Id.class);
        if (fields.length > 1) {
            throw new RuntimeException("Object contains more than one id!");
        }
        if (fields.length == 0) {
            return null;
        }
        fields[0].setAccessible(true);
        try {
            return (Long)fields[0].get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    private <T extends AbstractEntity> void setEntityId(T object, Long id) {
        Field[] fields = Reflections.findAnnotatedFields(object, Id.class);
        if (fields.length > 1) {
            throw new RuntimeException("Object contains more than one id!");
        }
        if (fields.length == 0) {
            return;
        }
        fields[0].setAccessible(true);
        try {
            fields[0].set(object, id);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private synchronized Long generateId() {
        rotateCounter = rotateCounter >= 9999 ? 0 : ++rotateCounter;
        Calendar cal = Calendar.getInstance();
        String template = String.format("%04d%02d%02d%02d%02d%02d%04d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), rotateCounter);
        return Long.parseLong(template);
    }
}

