/*
 * Decompiled with CFR 0.152.
 */
package cz.tvrzna.dbrunk.databases;

import cz.tvrzna.dbrunk.Database;
import cz.tvrzna.dbrunk.DbConcurrentMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FileDatabase
implements Database {
    private RandomAccessFile raf;
    private ConcurrentMap<String, DbConcurrentMap<?>> database;

    public FileDatabase(String filePath) throws IOException {
        File file = new File(filePath);
        this.raf = new RandomAccessFile(file, "rw");
        if (!file.exists() || file.length() == 0L) {
            this.database = new ConcurrentHashMap();
            this.commit();
        }
        this.raf.seek(0L);
        byte[] content = new byte[(int)file.length()];
        this.raf.read(content, 0, (int)file.length());
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            this.database = (ConcurrentMap)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        ois.close();
        bais.close();
    }

    @Override
    public <T> DbConcurrentMap<T> createOrOpen(String tableName, Class<T> clazz) {
        return this.database.computeIfAbsent(tableName, k -> new DbConcurrentMap(clazz));
    }

    @Override
    public void drop(String tableName) {
        this.database.remove(tableName);
    }

    @Override
    public void commit() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.database);
        this.raf.seek(0L);
        this.raf.write(baos.toByteArray());
        oos.close();
        baos.close();
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }
}

