/*
 * Decompiled with CFR 0.152.
 */
package cz.tvrzna.dbrunk.repositories;

import cz.tvrzna.dbrunk.annotations.Id;
import cz.tvrzna.dbrunk.utils.Reflections;
import java.io.Serializable;
import java.lang.reflect.Field;

public abstract class AbstractEntity
implements Serializable {
    private static final long serialVersionUID = 3506228068534759272L;

    private Field getIdField() {
        Field[] arrFields = Reflections.findAnnotatedFields(this, Id.class);
        if (arrFields.length > 0) {
            return arrFields[0];
        }
        return null;
    }

    private String getIdFieldName() {
        Field field = this.getIdField();
        return field != null ? field.getName() : null;
    }

    private Long getIdValue() {
        Field field = this.getIdField();
        if (field != null) {
            field.setAccessible(true);
            try {
                return (Long)field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.getIdValue() != null ? this.getIdValue().hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (null == object || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractEntity other = (AbstractEntity)object;
        return (this.getIdValue() != null || other.getIdValue() == null) && (this.getIdValue() == null || this.getIdValue().equals(other.getIdValue()));
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.getIdFieldName() + "=" + this.getIdValue() + "]";
    }
}

