/*
 * Decompiled with CFR 0.152.
 */
package cz.tvrzna.dbrunk.repositories;

import cz.tvrzna.dbrunk.DbrunkService;
import cz.tvrzna.dbrunk.repositories.AbstractEntity;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractRepository<T extends AbstractEntity>
implements Serializable {
    private static final long serialVersionUID = 1922380533400857928L;
    private final Class<T> clazz;
    private DbrunkService databaseService;

    public AbstractRepository(Class<T> clazz, boolean useDefault) {
        if (useDefault) {
            this.databaseService = DbrunkService.getInstance();
        }
        this.clazz = clazz;
    }

    public AbstractRepository(Class<T> clazz, DbrunkService databaseService) {
        this.databaseService = databaseService;
        this.clazz = clazz;
    }

    protected void setDbrunkService(DbrunkService databaseService) {
        this.databaseService = databaseService;
    }

    protected DbrunkService getDbrunkService() {
        return this.databaseService;
    }

    public T save(T entity) {
        return this.getDbrunkService().save(this.clazz, entity);
    }

    public T find(Long id) {
        return this.getDbrunkService().find(this.clazz, id);
    }

    public List<T> findAll() {
        return this.getDbrunkService().findAll(this.clazz);
    }

    public void remove(Long id) {
        this.getDbrunkService().remove(this.clazz, id);
    }

    public void remove(T entity) {
        this.getDbrunkService().remove(this.clazz, entity);
    }

    public void removeAll() {
        this.getDbrunkService().removeAll(this.clazz);
    }
}

