/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.db;

import cz.xtf.builder.builders.pod.PersistentVolumeClaim;
import cz.xtf.builder.db.AbstractDatabase;
import cz.xtf.builder.db.SQLExecutor;
import cz.xtf.builder.db.SQLExecutorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public abstract class AbstractSQLDatabase
extends AbstractDatabase
implements SQLExecutor {
    public AbstractSQLDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        super(symbolicName, dataDir, withLivenessProbe, withReadinessProbe, configureEnvironment);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(username, password, dbName, symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        super(username, password, dbName, symbolicName, dataDir, withLivenessProbe, withReadinessProbe, configureEnvironment);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(symbolicName, dataDir, pvc, withLivenessProbe, withReadinessProbe);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        super(symbolicName, dataDir, pvc);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        super(username, password, dbName, symbolicName, dataDir, pvc);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir) {
        super(username, password, dbName, symbolicName, dataDir);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir) {
        super(symbolicName, dataDir);
    }

    @Override
    public void executeSQL(Consumer<Connection> execute) {
        this.getSQLExecutor("127.0.0.1", this.getPort()).executeSQL(execute);
    }

    @Override
    public void executeSQLFile(String resourceName) {
        this.executeSQL(db -> {
            try {
                IOUtils.readLines((InputStream)AbstractSQLDatabase.class.getResourceAsStream(resourceName)).forEach(x -> {
                    try {
                        db.createStatement().execute((String)x);
                    }
                    catch (SQLException e) {
                        throw new IllegalArgumentException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public SQLExecutor getSQLExecutor(String hostname, int port) {
        return new SQLExecutorImpl(String.format(this.getJDBCConnectionStringPattern(), hostname, port, this.getDbName()), this.getUsername(), this.getPassword());
    }

    protected abstract String getJDBCConnectionStringPattern();
}

