/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.AbstractBuilder;
import cz.xtf.builder.builders.ApplicationBuilder;
import cz.xtf.builder.builders.PodBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.Collections;
import java.util.LinkedList;

public class DeploymentConfigBuilder
extends AbstractBuilder<DeploymentConfig, DeploymentConfigBuilder> {
    public static final String SYNCHRONOUS_LABEL = "synchronousId";
    private int replicas = 1;
    private String strategy = "Recreate";
    private PodBuilder podBuilder;
    private boolean imageChangeTrigger = false;
    private boolean configurationChangeTrigger = false;
    private boolean manualTrigger = false;
    private int synchronousDeployment = -1;

    public DeploymentConfigBuilder(String name) {
        this(null, name);
    }

    DeploymentConfigBuilder(ApplicationBuilder applicationBuilder, String name) {
        super(applicationBuilder, name);
        this.podBuilder = new PodBuilder(this, name);
    }

    public PodBuilder podTemplate() {
        return this.podBuilder;
    }

    public DeploymentConfigBuilder setReplicas(int replicas) {
        this.replicas = replicas;
        return this;
    }

    public DeploymentConfigBuilder setRollingStrategy() {
        this.strategy = "Rolling";
        return this;
    }

    public DeploymentConfigBuilder setRecreateStrategy() {
        this.strategy = "Recreate";
        return this;
    }

    public DeploymentConfigBuilder onImageChange() {
        this.imageChangeTrigger = true;
        return this;
    }

    public DeploymentConfigBuilder onConfigurationChange() {
        this.configurationChangeTrigger = true;
        return this;
    }

    public DeploymentConfigBuilder onManualDeployment() {
        this.manualTrigger = true;
        return this;
    }

    @Override
    public DeploymentConfig build() {
        LinkedList<DeploymentTriggerPolicy> triggers = new LinkedList<DeploymentTriggerPolicy>();
        if (this.imageChangeTrigger) {
            this.podBuilder.getContainers().stream().forEach(container -> {
                ObjectReferenceBuilder imageRef = (ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("ImageStreamTag")).withName(container.getImageName() + ":latest");
                if (container.getImageNamespace() != null) {
                    imageRef.withNamespace(container.getImageNamespace());
                }
                triggers.add(((DeploymentTriggerPolicyBuilder)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyBuilder)new DeploymentTriggerPolicyBuilder().withType("ImageChange")).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withContainerNames(new String[]{container.getName()})).withFrom(imageRef.build())).endImageChangeParams()).build());
            });
        }
        if (this.configurationChangeTrigger) {
            triggers.add(((DeploymentTriggerPolicyBuilder)new DeploymentTriggerPolicyBuilder().withType("ConfigChange")).build());
        }
        if (this.manualTrigger) {
            triggers.add(((DeploymentTriggerPolicyBuilder)new DeploymentTriggerPolicyBuilder().withType("Manual")).build());
        }
        if (this.synchronousDeployment >= 0) {
            String synchronousId = Integer.toString(this.synchronousDeployment);
            this.addLabel(SYNCHRONOUS_LABEL, synchronousId);
            this.podBuilder.addLabel(SYNCHRONOUS_LABEL, synchronousId);
        }
        Pod pod = this.podBuilder.build();
        DeploymentConfigSpecBuilder spec = (DeploymentConfigSpecBuilder)((DeploymentConfigSpecFluent.TemplateNested)((DeploymentConfigSpecFluent.TemplateNested)((DeploymentConfigSpecBuilder)((DeploymentConfigSpecFluent.StrategyNested)((DeploymentConfigSpecBuilder)((DeploymentConfigSpecBuilder)((DeploymentConfigSpecBuilder)new DeploymentConfigSpecBuilder().withTriggers(triggers)).withReplicas(Integer.valueOf(this.replicas))).withSelector(Collections.singletonMap("name", this.podBuilder.getName()))).withNewStrategy().withType(this.strategy)).endStrategy()).withNewTemplate().withMetadata(pod.getMetadata())).withSpec(pod.getSpec())).endTemplate();
        return ((io.fabric8.openshift.api.model.DeploymentConfigBuilder)((io.fabric8.openshift.api.model.DeploymentConfigBuilder)new io.fabric8.openshift.api.model.DeploymentConfigBuilder().withMetadata(this.metadataBuilder().build())).withSpec(spec.build())).build();
    }

    public void synchronousDeployment() {
        if (this.synchronousDeployment < 0) {
            this.synchronousDeployment = 0;
        }
    }

    public void synchronousDeployment(int sequenceNumber) {
        assert (sequenceNumber >= 0) : "Negative sequence number given";
        this.synchronousDeployment = sequenceNumber;
    }

    @Override
    protected DeploymentConfigBuilder getThis() {
        return this;
    }

    public DeploymentConfigBuilder resetTriggers() {
        this.imageChangeTrigger = false;
        this.manualTrigger = false;
        this.configurationChangeTrigger = false;
        return this;
    }
}

