/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.AbstractBuilder;
import cz.xtf.builder.builders.ApplicationBuilder;
import cz.xtf.builder.builders.route.TransportProtocol;
import io.fabric8.kubernetes.api.model.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EndpointBuilder
extends AbstractBuilder<Endpoints, EndpointBuilder> {
    private final List<String> endpointIPs = new ArrayList<String>();
    private final List<Port> ports = new ArrayList<Port>();

    public EndpointBuilder(String id) {
        this(null, id);
    }

    EndpointBuilder(ApplicationBuilder applicationBuilder, String id) {
        super(applicationBuilder, id);
    }

    public EndpointBuilder addIP(String ip) {
        this.endpointIPs.add(ip);
        return this;
    }

    public EndpointBuilder addPort(int port) {
        return this.addPort(port, TransportProtocol.TCP);
    }

    public EndpointBuilder addPort(int port, TransportProtocol protocol) {
        this.ports.add(new Port(port, protocol));
        return this;
    }

    @Override
    public Endpoints build() {
        if (this.endpointIPs.isEmpty() || this.ports.isEmpty()) {
            throw new IllegalStateException("IP list and port list must be non-empty");
        }
        EndpointSubsetBuilder subset = (EndpointSubsetBuilder)((EndpointSubsetBuilder)new EndpointSubsetBuilder().withAddresses(this.endpointIPs.stream().map(ip -> ((EndpointAddressBuilder)new EndpointAddressBuilder().withIp(ip)).build()).collect(Collectors.toList()))).withPorts(this.ports.stream().map(port -> ((EndpointPortBuilder)((EndpointPortBuilder)new EndpointPortBuilder().withPort(Integer.valueOf(port.getPort()))).withProtocol(port.getTransportProtocol().toString())).build()).collect(Collectors.toList()));
        return ((EndpointsBuilder)((EndpointsBuilder)new EndpointsBuilder().withMetadata(this.metadataBuilder().build())).withSubsets(new EndpointSubset[]{subset.build()})).build();
    }

    @Override
    protected EndpointBuilder getThis() {
        return this;
    }

    private class Port {
        private int port;
        private TransportProtocol transportProtocol;

        public int getPort() {
            return this.port;
        }

        public TransportProtocol getTransportProtocol() {
            return this.transportProtocol;
        }

        public Port(int port, TransportProtocol transportProtocol) {
            this.port = port;
            this.transportProtocol = transportProtocol;
        }
    }
}

