/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.waiting.failfast;

import cz.xtf.core.bm.BuildManagers;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.failfast.EventFailFastCheckBuilder;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import cz.xtf.core.waiting.failfast.MultipleFailFastChecksHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FailFastBuilder {
    private final List<OpenShift> openShifts = new ArrayList<OpenShift>();
    private final List<FailFastCheck> failFastChecks = new ArrayList<FailFastCheck>();

    private FailFastBuilder(OpenShift ... openShifts) {
        if (openShifts.length == 0) {
            this.openShifts.add(OpenShifts.master());
        } else {
            this.openShifts.addAll(Arrays.asList(openShifts));
        }
    }

    public static FailFastBuilder ofTestAndBuildNamespace() {
        return FailFastBuilder.ofOpenShifts(OpenShifts.master(), BuildManagers.get().openShift());
    }

    public static FailFastBuilder ofOpenShifts(OpenShift ... openShifts) {
        return new FailFastBuilder(openShifts);
    }

    public EventFailFastCheckBuilder events() {
        return new EventFailFastCheckBuilder(this);
    }

    void addFailFastCheck(FailFastCheck check) {
        this.failFastChecks.add(check);
    }

    List<OpenShift> getOpenshifts() {
        return this.openShifts;
    }

    public FailFastCheck build() {
        return new MultipleFailFastChecksHandler(this.failFastChecks);
    }
}

