/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.bm;

import cz.xtf.core.bm.ManagedBuild;
import cz.xtf.core.bm.ManagedBuildReference;
import cz.xtf.core.config.BuildManagerConfig;
import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.Waiter;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildManager {
    private static final Logger log = LoggerFactory.getLogger(BuildManager.class);
    private final OpenShift openShift;

    public BuildManager(OpenShift openShift) {
        this.openShift = openShift;
        if (openShift.getProject(openShift.getNamespace()) == null) {
            openShift.createProjectRequest();
            openShift.waiters().isProjectReady().waitFor();
            try {
                ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((Resource)OpenShifts.admin().namespaces().withName(openShift.getNamespace())).edit()).editMetadata().addToLabels("xtf.cz/managed", "true")).endMetadata()).done();
            }
            catch (KubernetesClientException e) {
                log.warn("Couldn't assign label 'xtf.cz/managed' to the new project '" + openShift.getNamespace() + "'. Possible cause are insufficient permissions.");
                log.debug(e.getMessage());
            }
        }
        if (OpenShiftConfig.pullSecret() != null) {
            openShift.setupPullSecret(OpenShiftConfig.pullSecret());
        }
        openShift.addRoleToGroup("system:image-puller", "ClusterRole", "system:authenticated");
    }

    public ManagedBuildReference deploy(ManagedBuild managedBuild) {
        if (BuildManagerConfig.forceRebuild()) {
            log.info("Force rebuilding is enabled... Building '{}' ...", (Object)managedBuild.getId());
            managedBuild.delete(this.openShift);
            managedBuild.build(this.openShift);
        } else if (!managedBuild.isPresent(this.openShift)) {
            log.info("Managed build '{}' is not present... Building...", (Object)managedBuild.getId());
            managedBuild.build(this.openShift);
        } else if (managedBuild.needsUpdate(this.openShift)) {
            log.info("Managed build '{}' is not up to date... Building...", (Object)managedBuild.getId());
            managedBuild.update(this.openShift);
        } else {
            log.info("Managed build '{}' is up to date.", (Object)managedBuild.getId());
        }
        return this.getBuildReference(managedBuild);
    }

    public Waiter hasBuildCompleted(ManagedBuild managedBuild) {
        return managedBuild.hasCompleted(this.openShift);
    }

    public ManagedBuildReference getBuildReference(ManagedBuild managedBuild) {
        return new ManagedBuildReference(managedBuild.getId(), "latest", this.openShift.getNamespace());
    }

    public OpenShift openShift() {
        return this.openShift;
    }
}

