/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.http.Https;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftBinary;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.openshift.api.model.Route;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShifts {
    private static final Logger log = LoggerFactory.getLogger(OpenShifts.class);
    private static final String OCP3_CLIENTS_URL = "https://mirror.openshift.com/pub/openshift-v3/clients";
    private static final String OCP4_CLIENTS_URL = "https://mirror.openshift.com/pub/openshift-v4";
    private static OpenShift adminUtil;
    private static OpenShift masterUtil;
    private static volatile String openShiftBinaryPath;

    public static OpenShift admin() {
        if (adminUtil == null) {
            adminUtil = OpenShifts.admin(OpenShiftConfig.namespace());
        }
        return adminUtil;
    }

    public static OpenShift admin(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.adminToken())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.adminToken());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.adminUsername())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.adminUsername(), OpenShiftConfig.adminPassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.adminKubeconfig())) {
            return OpenShift.get(Paths.get(OpenShiftConfig.adminKubeconfig(), new String[0]), namespace);
        }
        return OpenShift.get(namespace);
    }

    public static OpenShift master() {
        if (masterUtil == null) {
            masterUtil = OpenShifts.master(OpenShiftConfig.namespace());
        }
        return masterUtil;
    }

    public static OpenShift master(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.masterToken())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.masterToken());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.masterUsername())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.masterUsername(), OpenShiftConfig.masterPassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.masterKubeconfig())) {
            return OpenShift.get(Paths.get(OpenShiftConfig.masterKubeconfig(), new String[0]), namespace);
        }
        return OpenShift.get(namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getBinaryPath() {
        if (openShiftBinaryPath != null) return openShiftBinaryPath;
        Class<OpenShifts> clazz = OpenShifts.class;
        synchronized (OpenShifts.class) {
            if (openShiftBinaryPath != null) return openShiftBinaryPath;
            openShiftBinaryPath = OpenShiftConfig.binaryPath() != null ? OpenShiftConfig.binaryPath() : OpenShifts.downloadOpenShiftBinary(OpenShifts.getVersion());
            // ** MonitorExit[var0] (shouldn't be in output)
            return openShiftBinaryPath;
        }
    }

    public static OpenShiftBinary masterBinary() {
        return OpenShifts.masterBinary(OpenShiftConfig.namespace());
    }

    public static OpenShiftBinary masterBinary(String namespace) {
        return OpenShifts.getBinary(OpenShiftConfig.masterToken(), OpenShiftConfig.masterUsername(), OpenShiftConfig.masterPassword(), OpenShiftConfig.masterKubeconfig(), namespace);
    }

    public static OpenShiftBinary adminBinary() {
        return OpenShifts.adminBinary(OpenShiftConfig.namespace());
    }

    public static OpenShiftBinary adminBinary(String namespace) {
        return OpenShifts.getBinary(OpenShiftConfig.adminToken(), OpenShiftConfig.adminUsername(), OpenShiftConfig.adminPassword(), OpenShiftConfig.adminKubeconfig(), namespace);
    }

    private static OpenShiftBinary getBinary(String token, String username, String password, String kubeconfig, String namespace) {
        OpenShiftBinary openShiftBinary;
        String ocConfigPath = OpenShifts.createUniqueOcConfigFolder().resolve("oc.config").toAbsolutePath().toString();
        if (StringUtils.isNotEmpty((CharSequence)token) || StringUtils.isNotEmpty((CharSequence)username)) {
            openShiftBinary = new OpenShiftBinary(OpenShifts.getBinaryPath(), ocConfigPath);
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                openShiftBinary.login(OpenShiftConfig.url(), token);
            } else {
                openShiftBinary.login(OpenShiftConfig.url(), username, password);
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)kubeconfig)) {
                try {
                    Files.copy(Paths.get(kubeconfig, new String[0]), Paths.get(ocConfigPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                File defaultKubeConfig = Paths.get(OpenShifts.getHomeDir(), ".kube", "config").toFile();
                if (defaultKubeConfig.isFile()) {
                    try {
                        Files.copy(defaultKubeConfig.toPath(), Paths.get(ocConfigPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    throw new RuntimeException(defaultKubeConfig.getAbsolutePath() + " does not exist and no other OpenShift master option specified");
                }
            }
            openShiftBinary = new OpenShiftBinary(OpenShifts.getBinaryPath(), ocConfigPath);
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            openShiftBinary.project(namespace);
        }
        return openShiftBinary;
    }

    private static String getHomeDir() {
        File f;
        String home = System.getenv("HOME");
        if (home != null && !home.isEmpty() && (f = new File(home)).exists() && f.isDirectory()) {
            return home;
        }
        return System.getProperty("user.home", ".");
    }

    private static String getSystemTypeForOCP3() {
        String systemType = "linux";
        if (SystemUtils.IS_OS_MAC) {
            systemType = "macosx";
        } else if (OpenShifts.isS390x()) {
            systemType = systemType + "-s390x";
        } else if (OpenShifts.isPpc64le()) {
            systemType = systemType + "-ppc64le";
        }
        return systemType;
    }

    private static String getSystemTypeForOCP4() {
        String systemType = "amd64";
        if (OpenShifts.isS390x()) {
            systemType = "s390x";
        } else if (OpenShifts.isPpc64le()) {
            systemType = "ppc64le";
        }
        return systemType;
    }

    private static boolean isPpc64le() {
        return "ppc64le".equals(SystemUtils.OS_ARCH) || SystemUtils.OS_VERSION.contains("ppc64le");
    }

    private static boolean isS390x() {
        return SystemUtils.IS_OS_ZOS || "s390x".equals(SystemUtils.OS_ARCH) || SystemUtils.OS_VERSION.contains("s390x");
    }

    private static String downloadOpenShiftBinary(String version) {
        String ocFileName;
        String clientLocation;
        if (version.startsWith("3")) {
            clientLocation = String.format("%s/%s/%s/", OCP3_CLIENTS_URL, version, OpenShifts.getSystemTypeForOCP3());
            ocFileName = "oc.tar.gz";
        } else if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.version())) {
            clientLocation = String.format("%s/%s/clients/ocp/%s/", OCP4_CLIENTS_URL, OpenShifts.getSystemTypeForOCP4(), version);
            ocFileName = SystemUtils.IS_OS_MAC ? "openshift-client-mac.tar.gz" : "openshift-client-linux.tar.gz";
        } else {
            return OpenShifts.downloadClientFromClusterRoute(version);
        }
        return OpenShifts.downloadOpenShiftBinaryInternal(version, ocFileName, clientLocation, false);
    }

    private static String downloadClientFromClusterRoute(String version) {
        Optional<Route> downloadsRouteOptional = Optional.ofNullable(OpenShifts.admin("openshift-console").getRoute("downloads"));
        Route downloads = downloadsRouteOptional.orElseThrow(() -> new IllegalStateException("We are not able to find download link for OC binary."));
        String clientLocation = String.format("https://" + downloads.getSpec().getHost() + "/%s/%s/", OpenShifts.getSystemTypeForOCP4(), SystemUtils.IS_OS_MAC ? "mac" : "linux");
        return OpenShifts.downloadOpenShiftBinaryInternal(version, "oc.tar", clientLocation, true);
    }

    private static String downloadOpenShiftBinaryInternal(String version, String ocFileName, String clientLocation, boolean trustAll) {
        int code = Https.httpsGetCode(clientLocation);
        if (version.startsWith("3") && code == 404) {
            clientLocation = clientLocation.replace(version, version.concat("-1"));
            code = Https.httpsGetCode(clientLocation);
        }
        if (code != 200) {
            throw new IllegalStateException("Client binary for version " + version + " isn't available at " + clientLocation);
        }
        File workdir = OpenShifts.ocBinaryFolder();
        File ocTarFile = new File(workdir, "oc.tar.gz");
        File ocFile = new File(workdir, "oc");
        String ocUrl = clientLocation + ocFileName;
        try {
            URL requestUrl = new URL(ocUrl);
            log.info("downloading from {} ", (Object)ocUrl);
            File cachedOcTarFile = OpenShifts.getOcFromCache(version, ocUrl, ocTarFile);
            if (!OpenShiftConfig.isBinaryCacheEnabled() || !cachedOcTarFile.exists()) {
                if (trustAll) {
                    Https.copyHttpsURLToFile(requestUrl, ocTarFile, 20000, 300000);
                } else {
                    FileUtils.copyURLToFile((URL)requestUrl, (File)ocTarFile, (int)20000, (int)300000);
                }
                OpenShifts.saveOcOnCache(version, ocUrl, ocTarFile);
            } else {
                FileUtils.copyFile((File)cachedOcTarFile, (File)ocTarFile);
            }
            OpenShifts.executeCommand("tar", "-xf", ocTarFile.getPath(), "-C", workdir.getPath());
            FileUtils.deleteQuietly((File)ocTarFile);
            return ocFile.getAbsolutePath();
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Failed to download and extract oc binary from " + ocUrl, e);
        }
    }

    public static void saveOcOnCache(String version, String ocUrl, File ocTarFile) throws IOException {
        if (OpenShiftConfig.isBinaryCacheEnabled()) {
            File cacheRootFile = new File(OpenShiftConfig.binaryCachePath());
            if (!cacheRootFile.exists() && !cacheRootFile.mkdirs()) {
                throw new IllegalStateException("Cannot mkdirs " + cacheRootFile);
            }
            Path cachePath = OpenShifts.getOcCachePath(version, ocUrl);
            Files.createDirectories(cachePath, new FileAttribute[0]);
            FileUtils.copyFile((File)ocTarFile, (File)new File(cachePath.toFile(), ocTarFile.getName()));
        }
    }

    public static File getOcFromCache(String version, String ocUrl, File ocTarFile) throws IOException {
        return new File(OpenShifts.getOcCachePath(version, ocUrl).toFile(), ocTarFile.getName());
    }

    private static Path getOcCachePath(String version, String ocUrl) {
        return Paths.get(OpenShiftConfig.binaryCachePath(), version, DigestUtils.md5Hex((String)ocUrl));
    }

    public static String getVersion() {
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.version())) {
            return OpenShiftConfig.version();
        }
        String ocp3UrlVersion = OpenShiftConfig.url() + "/version/openshift";
        if (Https.getCode(ocp3UrlVersion) == 200) {
            String content = Https.httpsGetContent(ocp3UrlVersion);
            return ModelNode.fromJSONString((String)content).get("gitVersion").asString().replaceAll("^v(.*)", "$1");
        }
        CustomResourceDefinitionContext crdContext = new CustomResourceDefinitionContext.Builder().withGroup("config.openshift.io").withPlural("clusterversions").withScope("NonNamespaced").withVersion("v1").build();
        return OpenShifts.toString(OpenShifts.toMap(OpenShifts.toMap(OpenShifts.admin().customResource(crdContext).get("version"), "status"), "desired"), "version");
    }

    private static String toString(Object map, String key) {
        return (String)((Map)map).get(key);
    }

    private static Map toMap(Object map, String key) {
        return (Map)((Map)map).get(key);
    }

    public static String getMasterToken() {
        return OpenShifts.getToken(OpenShiftConfig.masterToken(), OpenShiftConfig.masterUsername(), OpenShiftConfig.masterPassword(), OpenShiftConfig.masterKubeconfig());
    }

    public static String getAdminToken() {
        return OpenShifts.getToken(OpenShiftConfig.adminToken(), OpenShiftConfig.adminUsername(), OpenShiftConfig.adminPassword(), OpenShiftConfig.adminKubeconfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getToken(String token, String username, String password, String kubeconfig) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            HttpURLConnection connection = null;
            try {
                connection = OpenShiftConfig.version().startsWith("3") ? Https.getHttpsConnection(new URL(OpenShiftConfig.url() + "/oauth/authorize?response_type=token&client_id=openshift-challenging-client")) : Https.getHttpsConnection(new URL("https://oauth-openshift.apps." + StringUtils.substringBetween((String)OpenShiftConfig.url(), (String)"api.", (String)":") + "/oauth/authorize?response_type=token&client_id=openshift-challenging-client"));
                String encoded = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                Map<String, List<String>> headers = connection.getHeaderFields();
                connection.disconnect();
                List<String> location = headers.get("Location");
                if (location != null) {
                    Optional<String> acces_token = location.stream().filter(s -> s.contains("access_token")).findFirst();
                    String string = acces_token.map(s -> StringUtils.substringBetween((String)s, (String)"#access_token=", (String)"&")).orElse(null);
                    return string;
                }
            }
            catch (IOException ex) {
                log.error("Unable to retrieve token from Location header: {} ", (Object)ex.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)kubeconfig)) {
            try {
                Config config = Config.fromKubeconfig(null, (String)new String(Files.readAllBytes(Paths.get(kubeconfig, new String[0])), StandardCharsets.UTF_8), (String)kubeconfig);
                return config.getOauthToken();
            }
            catch (IOException e) {
                log.error("Unable to retrieve token from kubeconfig: {} ", (Object)kubeconfig, (Object)e);
                return null;
            }
        }
        File defaultKubeConfig = Paths.get(OpenShifts.getHomeDir(), ".kube", "config").toFile();
        try {
            Config config = Config.fromKubeconfig(null, (String)new String(Files.readAllBytes(defaultKubeConfig.toPath()), StandardCharsets.UTF_8), (String)defaultKubeConfig.getAbsolutePath());
            return config.getOauthToken();
        }
        catch (IOException e) {
            log.error("Unable to retrieve token from default kubeconfig: {} ", (Object)defaultKubeConfig, (Object)e);
            return null;
        }
    }

    private static void executeCommand(String ... args) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        int result = pb.start().waitFor();
        if (result != 0) {
            throw new IOException("Failed to execute: " + Arrays.toString(args));
        }
    }

    private static Path createUniqueOcConfigFolder() {
        try {
            return Files.createTempDirectory(OpenShifts.ocBinaryFolder().toPath(), "config", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Temporary folder for oc config couldn't be created", e);
        }
    }

    private static File ocBinaryFolder() {
        File workdir = new File(Paths.get("tmp/oc", new String[0]).toAbsolutePath().toString());
        if (workdir.exists()) {
            return workdir;
        }
        if (!workdir.mkdirs()) {
            throw new IllegalStateException("Cannot mkdirs " + workdir);
        }
        return workdir;
    }
}

