/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.waiting.failfast;

import cz.xtf.core.event.EventList;
import cz.xtf.core.event.EventListFilter;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.waiting.failfast.FailFastBuilder;
import cz.xtf.core.waiting.failfast.WatchedResourcesSupplier;
import java.time.ZonedDateTime;
import java.util.Arrays;

public class EventFailFastCheckBuilder {
    private final FailFastBuilder failFastBuilder;
    private String[] names = null;
    private ZonedDateTime after;
    private String[] reasons;
    private String[] messages;
    private String[] types;
    private String[] kinds;

    EventFailFastCheckBuilder(FailFastBuilder failFastBuilder) {
        this.failFastBuilder = failFastBuilder;
    }

    public EventFailFastCheckBuilder ofNames(String ... name) {
        this.names = name;
        return this;
    }

    public EventFailFastCheckBuilder ofReasons(String ... reasons) {
        this.reasons = reasons;
        return this;
    }

    public EventFailFastCheckBuilder ofTypes(String ... types) {
        this.types = types;
        return this;
    }

    public EventFailFastCheckBuilder ofKinds(String ... kinds) {
        this.kinds = kinds;
        return this;
    }

    public EventFailFastCheckBuilder ofMessages(String ... messages) {
        this.messages = messages;
        return this;
    }

    public FailFastBuilder atLeastOneExists() {
        this.failFastBuilder.addFailFastCheck(new WatchedResourcesSupplier<EventList>(() -> this.getFilterEventList().collect(), eventList -> !eventList.isEmpty(), eventList -> this.failFastReason((EventList)eventList, "at least one exists")));
        return this.failFastBuilder;
    }

    private String failFastReason(EventList eventList, String condition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Following events match condition: <").append(condition).append(">\n");
        eventList.forEach(e -> stringBuilder.append("\t").append(e.getLastTimestamp()).append("\t").append(e.getInvolvedObject().getKind()).append("/").append(e.getInvolvedObject().getName()).append("\t").append(e.getMessage()).append("\n"));
        stringBuilder.append("Filter:");
        if (this.kinds != null) {
            stringBuilder.append("\t obj kinds: ").append(Arrays.toString(this.kinds)).append("\n");
        }
        if (this.names != null) {
            stringBuilder.append("\t obj names: ").append(Arrays.toString(this.names)).append("\n");
        }
        if (this.reasons != null) {
            stringBuilder.append("\t event reasons: ").append(Arrays.toString(this.reasons)).append("\n");
        }
        if (this.messages != null) {
            stringBuilder.append("\t messages: ").append(Arrays.toString(this.messages)).append("\n");
        }
        if (this.types != null) {
            stringBuilder.append("\t event types: ").append(Arrays.toString(this.types)).append("\n");
        }
        if (this.after != null) {
            stringBuilder.append("\t after: ").append(this.after.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public EventFailFastCheckBuilder after(ZonedDateTime after) {
        this.after = after;
        return this;
    }

    private EventListFilter getFilterEventList() {
        EventListFilter filter = this.getEventsForAllNamespaces().filter();
        if (this.names != null) {
            filter.ofObjNames(this.names);
        }
        if (this.after != null) {
            filter.inOneOfTimeWindows(this.after, ZonedDateTime.now());
        }
        if (this.reasons != null) {
            filter.ofReasons(this.reasons);
        }
        if (this.messages != null) {
            filter.ofMessages(this.messages);
        }
        if (this.types != null) {
            filter.ofEventTypes(this.types);
        }
        if (this.kinds != null) {
            filter.ofObjKinds(this.kinds);
        }
        return filter;
    }

    private EventList getEventsForAllNamespaces() {
        EventList events = null;
        for (OpenShift openShift : this.failFastBuilder.getOpenshifts()) {
            if (events == null) {
                events = openShift.getEventList();
                continue;
            }
            events.addAll(openShift.getEventList());
        }
        return events;
    }
}

