/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.crd.CustomResourceDefinitionContextProvider;
import cz.xtf.core.openshift.helpers.ResourceFunctions;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.SupplierWaiter;
import cz.xtf.core.waiting.Waiter;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public class OpenShiftWaiters {
    private OpenShift openShift;
    private FailFastCheck failFast;

    OpenShiftWaiters(OpenShift openShift) {
        this(openShift, () -> false);
    }

    OpenShiftWaiters(OpenShift openShift, FailFastCheck failFast) {
        this.openShift = openShift;
        this.failFast = failFast;
    }

    public static OpenShiftWaiters get(OpenShift openShift, FailFastCheck failFast) {
        return new OpenShiftWaiters(openShift, failFast);
    }

    public Waiter hasBuildCompleted(String buildConfigName) {
        Supplier<String> supplier = () -> Optional.ofNullable(this.openShift.getLatestBuild(buildConfigName)).map(Build::getMetadata).map(ObjectMeta::getName).map(this.openShift::getBuild).map(Build::getStatus).map(BuildStatus::getPhase).orElse(null);
        String reason = "Waiting for completion of latest build " + buildConfigName;
        return new SupplierWaiter<String>(supplier, "Complete"::equals, "Failed"::equals, TimeUnit.MILLISECONDS, WaitingConfig.buildTimeout(), reason).logPoint(Waiter.LogPoint.BOTH).failFast(this.failFast).interval(5000L);
    }

    public Waiter hasBuildCompleted(Build build) {
        Supplier<String> supplier = () -> this.openShift.getBuild(build.getMetadata().getName()).getStatus().getPhase();
        String reason = "Waiting for completion of build " + build.getMetadata().getName();
        return new SupplierWaiter<String>(supplier, "Complete"::equals, "Failed"::equals, TimeUnit.MILLISECONDS, WaitingConfig.buildTimeout(), reason).logPoint(Waiter.LogPoint.BOTH).failFast(this.failFast).interval(5000L);
    }

    public Waiter isLatestBuildPresent(String buildConfigName) {
        Supplier<Build> supplier = () -> this.openShift.getLatestBuild(buildConfigName);
        String reason = "Waiting for presence of latest build of buildconfig " + buildConfigName;
        return new SupplierWaiter<Build>(supplier, Objects::nonNull, reason).logPoint(Waiter.LogPoint.BOTH).failFast(this.failFast).interval(5000L);
    }

    public Waiter isProjectReady() {
        return new SimpleWaiter(() -> this.openShift.getProject() != null, TimeUnit.SECONDS, 20L, "Waiting for the project to be created.").failFast(this.failFast);
    }

    public Waiter isProjectClean() {
        return new SimpleWaiter(() -> {
            int crdInstances = 0;
            for (CustomResourceDefinitionContextProvider crdContextProvider : OpenShift.getCRDContextProviders()) {
                try {
                    crdInstances += ((List)this.openShift.customResource(crdContextProvider.getContext()).list(this.openShift.getNamespace()).get("items")).size();
                }
                catch (KubernetesClientException kubernetesClientException) {}
            }
            return crdInstances == 0 & this.openShift.listRemovableResources().isEmpty();
        }, TimeUnit.MILLISECONDS, WaitingConfig.timeoutCleanup(), "Cleaning project.").failFast(this.failFast);
    }

    public Waiter isDcReady(String dcName) {
        return this.isDcReady(dcName, Integer.MAX_VALUE);
    }

    public Waiter isDcReady(String dcName, int restartTolerance) {
        Supplier<List<Pod>> ps = () -> this.openShift.getPods(dcName);
        String reason = "Waiting till all pods created by " + dcName + " deployment config are ready";
        return this.isDeploymentReady(dcName, ps, restartTolerance).reason(reason);
    }

    public Waiter isDeploymentReady(String dcName, int version) {
        return this.isDeploymentReady(dcName, version, Integer.MAX_VALUE);
    }

    public Waiter isDeploymentReady(String dcName, int version, int restartTolerance) {
        Supplier<List<Pod>> ps = () -> this.openShift.getPods(dcName, version);
        String reason = "Waiting till all pods created by " + version + ". of " + dcName + " deployment config are ready";
        return this.isDeploymentReady(dcName, ps, restartTolerance).reason(reason);
    }

    private Waiter isDeploymentReady(String dcName, Supplier<List<Pod>> ps, int restartTolerance) {
        int replicas = this.openShift.getDeploymentConfig(dcName).getSpec().getReplicas();
        Function<List<Pod>, Boolean> sc = ResourceFunctions.areExactlyNPodsReady(replicas);
        Function<List<Pod>, Boolean> fc = ResourceFunctions.haveAnyPodRestartedAtLeastNTimes(restartTolerance);
        return new SupplierWaiter<List<Pod>>(ps, sc, fc).failFast(this.failFast);
    }

    public Waiter areExactlyNPodsReady(int n) {
        return this.areExactlyNPodsReady(n, this.openShift::getPods).reason("Waiting for exactly " + n + " pods to be ready.");
    }

    public Waiter areExactlyNPodsReady(int n, String dcName) {
        return this.areExactlyNPodsReady(n, "deploymentconfig", dcName);
    }

    public Waiter areExactlyNPodsReady(int n, String key, String value) {
        Supplier<List<Pod>> ps = () -> this.openShift.getLabeledPods(key, value);
        String reason = "Waiting for exactly " + n + " pods with label " + key + "=" + value + " to be ready.";
        return this.areExactlyNPodsReady(n, ps).reason(reason);
    }

    private Waiter areExactlyNPodsReady(int n, Supplier<List<Pod>> podSupplier) {
        return new SupplierWaiter<List<Pod>>(podSupplier, ResourceFunctions.areExactlyNPodsReady(n)).failFast(this.failFast);
    }

    public Waiter areExactlyNPodsRunning(int n) {
        return this.areExactlyNPodsRunning(n, this.openShift::getPods).reason("Waiting for exactly " + n + " pods to be running.");
    }

    public Waiter areExactlyNPodsRunning(int n, String dcName) {
        return this.areExactlyNPodsRunning(n, "deploymentconfig", dcName);
    }

    public Waiter areExactlyNPodsRunning(int n, String key, String value) {
        Supplier<List<Pod>> ps = () -> this.openShift.getLabeledPods(key, value);
        String reason = "Waiting for exactly " + n + " pods with label " + key + "=" + value + " to be running.";
        return this.areExactlyNPodsRunning(n, ps).reason(reason);
    }

    private Waiter areExactlyNPodsRunning(int n, Supplier<List<Pod>> podSupplier) {
        return new SupplierWaiter<List<Pod>>(podSupplier, ResourceFunctions.areExactlyNPodsRunning(n)).failFast(this.failFast);
    }

    public Waiter areNoPodsPresent(String dcName) {
        return this.areNoPodsPresent("deploymentconfig", dcName);
    }

    public Waiter areNoPodsPresent(String key, String value) {
        Supplier<List<Pod>> ps = () -> this.openShift.getLabeledPods(key, value);
        String reason = "Waiting for no present pods with label " + key + "=" + value + ".";
        return this.areNoPodsPresent(ps).reason(reason);
    }

    private Waiter areNoPodsPresent(Supplier<List<Pod>> podSupplier) {
        return new SupplierWaiter<List>(podSupplier, List::isEmpty).failFast(this.failFast);
    }

    public Waiter havePodsBeenRestarted(String dcName) {
        return this.havePodsBeenRestarted("deploymentconfig", dcName);
    }

    public Waiter havePodsBeenRestarted(String key, String value) {
        return this.havePodsBeenRestartedAtLeastNTimes(1, key, value);
    }

    public Waiter havePodsBeenRestartedAtLeastNTimes(int times, String dcName) {
        return this.havePodsBeenRestartedAtLeastNTimes(times, "deploymentconfig", dcName);
    }

    public Waiter havePodsBeenRestartedAtLeastNTimes(int times, String key, String value) {
        Supplier<List<Pod>> ps = () -> this.openShift.getLabeledPods(key, value);
        String reason = "Waiting for any pods with label " + key + "=" + value + " having a restart count >= " + times + ".";
        return this.havePodsBeenRestartedAtLeastNTimes(times, ps).reason(reason);
    }

    private Waiter havePodsBeenRestartedAtLeastNTimes(int times, Supplier<List<Pod>> podSupplier) {
        return new SupplierWaiter<List<Pod>>(podSupplier, ResourceFunctions.haveAnyPodRestartedAtLeastNTimes(times)).failFast(this.failFast);
    }
}

