/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.service.logs.streaming.k8s;

import cz.xtf.core.service.logs.streaming.ServiceLogColor;
import cz.xtf.core.service.logs.streaming.ServiceLogColoredPrintStream;
import cz.xtf.core.service.logs.streaming.ServiceLogUtils;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PodLogsWatcher
implements Watcher<Pod> {
    private static final Logger log = LoggerFactory.getLogger(PodLogsWatcher.class);
    private static final int LOG_TAILING_LINES = 100;
    private static final int LOG_WAIT_TIMEOUT = 60000;
    private KubernetesClient client;
    private String namespace;
    private PrintStream printStream;
    private Pattern filter;
    private List<ContainerStatus> runningStatusesBefore = Collections.emptyList();
    private List<ContainerStatus> terminatedStatusesBefore = Collections.emptyList();
    private final Map<String, LogWatch> logWatches = new HashMap<String, LogWatch>();

    protected PodLogsWatcher(KubernetesClient client, String namespace, PrintStream printStream, Pattern filter) {
        this.client = client;
        this.namespace = namespace;
        this.printStream = printStream;
        this.filter = filter;
    }

    private void handleNewRunningContainers(Pod pod) {
        List<ContainerStatus> existingContainersRunningStatuses = this.getRunningContainersStatuses(pod);
        log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("existingContainersRunningStatuses.size=%s names=%s existingContainersRunningStatuses=%s", existingContainersRunningStatuses.size(), existingContainersRunningStatuses.stream().map(cs -> cs.getName()).collect(Collectors.joining()), existingContainersRunningStatuses)));
        List<ContainerStatus> newContainersRunningStatuses = this.getNewContainers(this.runningStatusesBefore, existingContainersRunningStatuses);
        log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("newContainersRunningStatuses.size=%s names=%s newContainersRunningStatuses=%s", newContainersRunningStatuses.size(), newContainersRunningStatuses.stream().map(cs -> cs.getName()).collect(Collectors.joining()), newContainersRunningStatuses)));
        this.runningStatusesBefore = existingContainersRunningStatuses;
        for (ContainerStatus status : newContainersRunningStatuses) {
            log.info(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("Container %s.%s.%s running...", this.namespace, pod.getMetadata().getName(), status.getName())));
            log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("CONTAINER status: name=%s, started=%s, ready=%s \n\t waiting=%s \n\t running=%s \n\t terminated=%s \n\t complete status=%s", status.getName(), status.getStarted(), status.getReady(), status.getState().getWaiting(), status.getState().getRunning(), status.getState().getTerminated(), pod.getStatus())));
            if (this.filter != null && this.filter.matcher(pod.getMetadata().getName()).matches()) {
                log.info(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("Skipped Pod %s.%s", this.namespace, pod.getMetadata().getName())));
                continue;
            }
            if (this.filter != null && this.filter.matcher(status.getName()).matches()) {
                log.info(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("Skipped Container %s.%s.%s", this.namespace, pod.getMetadata().getName(), status.getName())));
                continue;
            }
            LogWatch lw = (LogWatch)((PrettyLoggable)((ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(pod.getMetadata().getName())).inContainer((Object)status.getName())).tailingLines(100)).withLogWaitTimeout(Integer.valueOf(60000)).watchLog((OutputStream)new ServiceLogColoredPrintStream.Builder().outputTo(this.printStream).withColor(ServiceLogColor.getNext()).withPrefix(this.forgeContainerLogPrefix(pod, status)).build());
            this.logWatches.put(status.getContainerID(), lw);
            log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("PodLogsWatcher started for Container %s in Pod %s in Namespace %s", status.getName(), pod.getMetadata().getName(), this.namespace)));
        }
    }

    private String forgeContainerLogPrefix(Pod pod, ContainerStatus status) {
        return String.format("%s.%s.%s", this.namespace, pod.getMetadata().getName(), status.getName());
    }

    private void handleNewTerminatedContainers(Pod pod) {
        List<ContainerStatus> existingContainersTerminatedStatuses = this.getTerminatedContainers(pod);
        log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("existingContainersTerminatedStatuses.size=%s names=%s existingContainersTerminatedStatuses=%s", existingContainersTerminatedStatuses.size(), existingContainersTerminatedStatuses.stream().map(cs -> cs.getName()).collect(Collectors.joining()), existingContainersTerminatedStatuses)));
        List<ContainerStatus> newContainersTerminatedStatuses = this.getNewContainers(this.terminatedStatusesBefore, existingContainersTerminatedStatuses);
        log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("newContainersTerminatedStatuses.size=%s names=%s newContainersTerminatedStatuses=%s", newContainersTerminatedStatuses.size(), newContainersTerminatedStatuses.stream().map(cs -> cs.getName()).collect(Collectors.joining()), newContainersTerminatedStatuses)));
        this.terminatedStatusesBefore = existingContainersTerminatedStatuses;
        for (ContainerStatus status : newContainersTerminatedStatuses) {
            log.info(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("Container %s.%s.%s was terminated!", this.namespace, pod.getMetadata().getName(), status.getName())));
            if (!this.logWatches.containsKey(status.getContainerID())) continue;
            this.logWatches.get(status.getContainerID()).close();
            log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage("Terminating PodLogsWatcher"));
            this.logWatches.remove(status.getContainerID());
        }
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("%s %s: %s", action.name(), pod.getMetadata().getName(), pod.getStatus())));
        switch (action) {
            case ADDED: {
                this.handleNewRunningContainers(pod);
                break;
            }
            case MODIFIED: {
                this.handleNewRunningContainers(pod);
                this.handleNewTerminatedContainers(pod);
                break;
            }
            case DELETED: 
            case ERROR: {
                this.handleNewTerminatedContainers(pod);
                break;
            }
            default: {
                log.error(ServiceLogUtils.getConventionallyPrefixedLogMessage(String.format("Unrecognized event: %s", action.name())));
                break;
            }
        }
    }

    private List<ContainerStatus> getNewContainers(List<ContainerStatus> before, List<ContainerStatus> now) {
        List namesBefore = before.stream().map(cs -> cs.getContainerID()).collect(Collectors.toList());
        return now.stream().filter(element -> !namesBefore.contains(element.getContainerID())).collect(Collectors.toList());
    }

    private List<ContainerStatus> getTerminatedContainers(Pod pod) {
        ArrayList<ContainerStatus> containers = new ArrayList<ContainerStatus>();
        containers.addAll(pod.getStatus().getInitContainerStatuses().stream().filter(containerStatus -> containerStatus.getState().getTerminated() != null).collect(Collectors.toList()));
        containers.addAll(pod.getStatus().getContainerStatuses().stream().filter(containerStatus -> containerStatus.getState().getTerminated() != null).collect(Collectors.toList()));
        return containers;
    }

    private List<ContainerStatus> getRunningContainersStatuses(Pod pod) {
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        statuses.addAll(pod.getStatus().getInitContainerStatuses().stream().filter(containerStatus -> containerStatus.getState().getRunning() != null).collect(Collectors.toList()));
        statuses.addAll(pod.getStatus().getContainerStatuses().stream().filter(containerStatus -> containerStatus.getState().getRunning() != null).collect(Collectors.toList()));
        return statuses;
    }

    public void onClose(WatcherException e) {
        this.logWatches.forEach((s, logWatch) -> logWatch.close());
        log.debug(ServiceLogUtils.getConventionallyPrefixedLogMessage("Terminating PodLogsWatcher"));
    }

    static class Builder {
        private KubernetesClient client;
        private String namespace;
        private PrintStream printStream;
        private Pattern filter;

        Builder() {
        }

        protected Builder withClient(KubernetesClient client) {
            this.client = client;
            return this;
        }

        protected Builder inNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        protected Builder outputTo(PrintStream printStream) {
            this.printStream = printStream;
            return this;
        }

        protected Builder filter(Pattern filter) {
            this.filter = filter;
            return this;
        }

        protected PodLogsWatcher build() {
            if (this.client == null) {
                throw new IllegalStateException("KubernetesClient must be specified!");
            }
            if (this.namespace == null) {
                throw new IllegalStateException("Namespace must be specified!");
            }
            if (this.printStream == null) {
                throw new IllegalStateException("PrintStream must be specified!");
            }
            return new PodLogsWatcher(this.client, this.namespace, this.printStream, this.filter);
        }
    }
}

