/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.config;

import cz.xtf.core.config.BackwardCompatibility;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XTFConfig {
    private static final Logger log = LoggerFactory.getLogger(XTFConfig.class);
    private static Path testPropertiesPath;
    private static Path globalPropertiesPath;
    private static final Properties properties;
    private static final String TEST_PROPERTIES_PATH = "xtf.test_properties.path";
    private static final String GLOBAL_TEST_PROPERTIES_PATH = "xtf.global_test_properties.path";

    public static void loadConfig() {
        properties.clear();
        globalPropertiesPath = XTFConfig.resolvePropertiesPath(System.getProperty(GLOBAL_TEST_PROPERTIES_PATH, "global-test.properties"));
        testPropertiesPath = XTFConfig.resolvePropertiesPath(System.getProperty(TEST_PROPERTIES_PATH, "test.properties"));
        properties.putAll((Map<?, ?>)XTFConfig.getPropertiesFromPath(globalPropertiesPath));
        properties.putAll((Map<?, ?>)XTFConfig.getPropertiesFromPath(testPropertiesPath));
        properties.putAll(System.getenv().entrySet().stream().collect(Collectors.toMap(e -> "xtf." + ((String)e.getKey()).replaceAll("_", ".").toLowerCase(), Map.Entry::getValue)));
        properties.putAll((Map<?, ?>)System.getProperties());
        BackwardCompatibility.updateProperties();
    }

    public static String get(String property) {
        return properties.getProperty(property);
    }

    public static String get(String property, String fallbackValue) {
        return properties.getProperty(property, fallbackValue);
    }

    static void setProperty(String property, String value) {
        properties.setProperty(property, value);
    }

    private static Path getProjectRoot() {
        Path dir = Paths.get("", new String[0]).toAbsolutePath();
        while (dir.getParent().resolve("pom.xml").toFile().exists()) {
            dir = dir.getParent();
        }
        return dir;
    }

    private static Path resolvePropertiesPath(String path) {
        if (Paths.get(path, new String[0]).toFile().exists()) {
            return Paths.get(path, new String[0]);
        }
        return XTFConfig.getProjectRoot().resolve(path);
    }

    private static Properties getPropertiesFromPath(Path path) {
        Properties properties = new Properties();
        if (Files.isReadable(path)) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(is);
            }
            catch (IOException ex) {
                log.warn("Unable to read properties from '{}'", (Object)path, (Object)ex);
            }
        }
        return properties;
    }

    static {
        properties = new Properties();
        XTFConfig.loadConfig();
    }
}

