/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.client;

import cz.xtf.client.HttpResponseParser;
import cz.xtf.client.HttpWaiters;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.LinkedList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class Http {
    private final URL url;
    private final HttpUriRequest request;
    private final Collection<ClientCookie> cookies;
    private final HttpWaiters waiters;
    private SSLConnectionSocketFactory sslsf;
    private String username;
    private String password;
    private boolean preemptiveAuth;
    private boolean disableRedirect;

    public static Http get(String url) throws MalformedURLException {
        return new Http(url, (HttpUriRequest)new HttpGet(url));
    }

    public static Http post(String url) throws MalformedURLException {
        return new Http(url, (HttpUriRequest)new HttpPost(url));
    }

    public static Http put(String url) throws MalformedURLException {
        return new Http(url, (HttpUriRequest)new HttpPut(url));
    }

    public static Http delete(String url) throws MalformedURLException {
        return new Http(url, (HttpUriRequest)new HttpDelete(url));
    }

    private Http(String url, HttpUriRequest request) throws MalformedURLException {
        this.url = new URL(url);
        this.request = request;
        this.cookies = new LinkedList<ClientCookie>();
        this.preemptiveAuth = false;
        this.disableRedirect = false;
        this.waiters = new HttpWaiters(this);
    }

    public Http basicAuth(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public Http bearerAuth(String token) {
        this.request.setHeader("Authorization", String.format("Bearer %s", token));
        return this;
    }

    public Http preemptiveAuth() {
        this.preemptiveAuth = true;
        return this;
    }

    public Http disableRedirect() {
        this.disableRedirect = true;
        return this;
    }

    public Http trustAll() {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
            this.sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.2"}, null, (HostnameVerifier)new NoopHostnameVerifier());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Can't create SSL connection factory trusting everything", e);
        }
        return this;
    }

    public Http trustStore(Path trustStorePath, String trustStorePassword) {
        return this.trustStore(trustStorePath, trustStorePassword, (HostnameVerifier)new DefaultHostnameVerifier());
    }

    public Http trustStore(Path trustStorePath, String trustStorePassword, HostnameVerifier verifier) {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStorePath.toFile(), trustStorePassword.toCharArray()).build();
            this.sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.2"}, null, verifier);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Can't create SSL connection factory", e);
        }
        return this;
    }

    public Http header(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public Http cookie(String name, String value) {
        this.cookies.add((ClientCookie)new BasicClientCookie(name, value));
        return this;
    }

    public Http cookie(String domain, String name, String value) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        this.cookies.add((ClientCookie)cookie);
        return this;
    }

    public Http data(String data, ContentType contentType) {
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalStateException("Can't add data to " + this.request.getClass().getSimpleName());
        }
        ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)new StringEntity(data, contentType));
        return this;
    }

    /*
     * Exception decompiling
     */
    public HttpResponseParser execute() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableHttpClient build() {
        HttpClientBuilder builder = HttpClients.custom();
        if (this.sslsf != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslsf);
        }
        if (this.username != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.url.getHost(), this.url.getPort() == -1 ? this.url.getDefaultPort() : this.url.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if (this.disableRedirect) {
            builder.disableRedirectHandling();
        }
        if (this.preemptiveAuth && this.username != null && this.password != null) {
            String credentials = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8), (boolean)false));
            this.request.setHeader("Authorization", String.format("Basic %s", credentials));
        }
        if (!this.cookies.isEmpty()) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            this.cookies.forEach(arg_0 -> ((CookieStore)cookieStore).addCookie(arg_0));
            builder.setDefaultCookieStore((CookieStore)cookieStore);
        }
        return builder.build();
    }

    public HttpWaiters waiters() {
        return this.waiters;
    }

    URL getUrl() {
        return this.url;
    }
}

