/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.client;

import cz.xtf.client.Http;
import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.Waiter;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;

public class HttpWaiters {
    private final Http client;

    HttpWaiters(Http httpClient) {
        this.client = httpClient;
    }

    public Waiter ok() {
        return this.code(200);
    }

    public Waiter code(int code) {
        BooleanSupplier bs = () -> {
            try {
                return this.client.execute().code() == code;
            }
            catch (IOException e) {
                return false;
            }
        };
        return new SimpleWaiter(bs, "Waiting for " + this.client.getUrl().toExternalForm() + " to return " + code).timeout(WaitingConfig.timeout());
    }

    public Waiter responseContains(String ... strings) {
        BooleanSupplier bs = () -> {
            try {
                String response = this.client.execute().response();
                return Stream.of(strings).allMatch(response::contains);
            }
            catch (IOException e) {
                return false;
            }
        };
        return new SimpleWaiter(bs, "Waiting for " + this.client.getUrl().toExternalForm() + " to contain (" + String.join((CharSequence)",", strings) + ")").timeout(WaitingConfig.timeout());
    }
}

