/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.junit5.config.JUnitConfig;
import cz.xtf.junit5.extensions.OpenShiftRecorderService;
import java.io.IOException;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftRecorderHandler
implements TestWatcher,
TestExecutionExceptionHandler,
BeforeAllCallback,
BeforeEachCallback,
LifecycleMethodExecutionExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(OpenShiftRecorderHandler.class);
    private final OpenShiftRecorderService openShiftRecorderService = new OpenShiftRecorderService();

    public void beforeAll(ExtensionContext context) {
        this.openShiftRecorderService.initFilters(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.openShiftRecorderService.updateFilters(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        try {
            this.openShiftRecorderService.recordState(context);
        }
        catch (Throwable t) {
            log.error("Throwable: ", t);
        }
        finally {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBeforeAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        try {
            if (JUnitConfig.recordBefore()) {
                this.openShiftRecorderService.recordState(context);
            }
        }
        catch (Throwable t) {
            log.error("Throwable: ", t);
        }
        finally {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        try {
            if (JUnitConfig.recordBefore()) {
                this.openShiftRecorderService.recordState(context);
            }
        }
        catch (Throwable t) {
            log.error("Throwable: ", t);
        }
        finally {
            throw throwable;
        }
    }

    public void testSuccessful(ExtensionContext context) {
        if (JUnitConfig.recordAlways()) {
            try {
                this.openShiftRecorderService.recordState(context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

