/*
 * Decompiled with CFR 0.152.
 */
package org.d_haven.mpool;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.d_haven.mpool.ObjectFactory;
import org.d_haven.mpool.Pool;
import org.d_haven.mpool.PoolListener;

public abstract class AbstractPool
implements Pool {
    private final Collection m_listeners;
    private final ObjectFactory m_factory;

    protected AbstractPool(ObjectFactory factory) {
        if (null == factory) {
            throw new IllegalArgumentException("'factory' must be provided");
        }
        this.m_listeners = new LinkedList();
        this.m_factory = factory;
    }

    public void addPoolListener(PoolListener listener) {
        this.m_listeners.add(listener);
    }

    public void removePoolListener(PoolListener listener) {
        this.m_listeners.remove(listener);
    }

    public Collection getPoolListeners() {
        return Collections.unmodifiableCollection(this.m_listeners);
    }

    public Object acquire() throws Exception {
        Object pooledObject = this.doAcquire();
        if (null == pooledObject) {
            try {
                pooledObject = this.newInstance();
            }
            catch (Exception e) {
                this.fireCreationFailedEvent(e);
                throw e;
            }
        }
        this.fireAquiredEvent(pooledObject);
        return pooledObject;
    }

    protected void fireCreationFailedEvent(Exception exception) {
        Iterator it = this.listenerIterator();
        while (it.hasNext()) {
            ((PoolListener)it.next()).objectCreationFailed(exception);
        }
    }

    private Iterator listenerIterator() {
        Iterator it = Collections.unmodifiableCollection(this.m_listeners).iterator();
        return it;
    }

    protected void fireAquiredEvent(Object pooledObject) {
        Iterator it = this.listenerIterator();
        while (it.hasNext()) {
            ((PoolListener)it.next()).objectAquired(pooledObject);
        }
    }

    protected void fireReleasedEvent(Object pooledObject) {
        Iterator it = this.listenerIterator();
        while (it.hasNext()) {
            ((PoolListener)it.next()).objectReleased(pooledObject);
        }
    }

    protected void fireDisposeFailedEvent(Object pooledObject, Exception exception) {
        Iterator it = this.listenerIterator();
        while (it.hasNext()) {
            ((PoolListener)it.next()).objectDisposalFailed(pooledObject, exception);
        }
    }

    protected void fireCreatedEvent(Object pooledObject) {
        Iterator it = this.listenerIterator();
        while (it.hasNext()) {
            ((PoolListener)it.next()).objectCreated(pooledObject);
        }
    }

    protected abstract Object doAcquire() throws Exception;

    public void release(Object pooledObject) {
        boolean destroy = this.doRelease(pooledObject);
        this.fireReleasedEvent(pooledObject);
        if (destroy) {
            this.disposeInstance(pooledObject);
        }
    }

    protected void disposeInstance(Object pooledObject) {
        try {
            this.m_factory.dispose(pooledObject);
            this.fireDisposedEvent(pooledObject);
        }
        catch (Exception e) {
            this.fireDisposeFailedEvent(pooledObject, e);
        }
    }

    protected void fireDisposedEvent(Object pooledObject) {
        Iterator it = this.listenerIterator();
        while (it.hasNext()) {
            ((PoolListener)it.next()).objectDisposed(pooledObject);
        }
    }

    protected abstract boolean doRelease(Object var1);

    public Object newInstance() throws Exception {
        Object object = this.m_factory.newInstance();
        this.fireCreatedEvent(object);
        return object;
    }
}

