/*
 * Decompiled with CFR 0.152.
 */
package org.d_haven.mpool;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.d_haven.event.SinkException;
import org.d_haven.event.command.Command;
import org.d_haven.event.command.CommandManager;
import org.d_haven.mpool.ManagablePool;
import org.d_haven.mpool.ManagePoolsCommand;
import org.d_haven.mpool.ObjectFactory;
import org.d_haven.mpool.Pool;
import org.d_haven.mpool.PoolManager;
import org.d_haven.mpool.VariableSizePool;

public class DefaultPoolManager
implements PoolManager {
    private final Map m_factoryMap = new HashMap();
    private List m_pools = new LinkedList();

    public DefaultPoolManager(CommandManager commandManager) throws SinkException {
        if (null == commandManager) {
            throw new IllegalArgumentException("'commandManager' must be provided");
        }
        commandManager.enqueueCommand((Command)new ManagePoolsCommand(this.m_pools));
    }

    public Pool getManagedPool(ObjectFactory factory, int initialEntries) throws Exception {
        ManagablePool pool = (ManagablePool)this.m_factoryMap.get(factory);
        if (null == pool) {
            pool = new VariableSizePool(factory, initialEntries);
            this.m_pools.add(pool);
            this.m_factoryMap.put(factory, pool);
        }
        return pool;
    }

    public String toString() {
        return this.getClass().getName() + "{m_pools=" + this.m_pools + '}';
    }
}

