/*
 * Decompiled with CFR 0.152.
 */
package org.d_haven.mpool;

import java.util.ArrayList;
import java.util.List;
import org.d_haven.mpool.AbstractPool;
import org.d_haven.mpool.ObjectFactory;
import org.d_haven.mpool.PoolException;

public final class FixedSizePool
extends AbstractPool {
    private boolean m_disposed;
    private final List m_buffer;
    private final long m_timeout;
    private final long m_stepTime;

    public FixedSizePool(ObjectFactory factory, int size) throws Exception {
        this(factory, size, -1L);
    }

    public FixedSizePool(ObjectFactory factory, int size, long timeout) throws Exception {
        super(factory);
        if (0 >= size) {
            throw new IllegalArgumentException("'size' must be greater than zero");
        }
        this.m_buffer = new ArrayList(size);
        this.m_disposed = false;
        this.m_timeout = timeout;
        this.m_stepTime = 0L == this.m_timeout ? 0L : Math.max(1L, this.m_timeout >> 1);
        for (int i = 0; i < size; ++i) {
            this.m_buffer.add(this.newInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doAcquire() throws Exception {
        Object object;
        long start = System.currentTimeMillis();
        long end = start + this.m_timeout;
        do {
            List list = this.m_buffer;
            synchronized (list) {
                if (-1L < this.m_timeout && 0 == this.m_buffer.size()) {
                    this.m_buffer.wait(this.m_stepTime);
                }
                object = 0 < this.m_buffer.size() ? this.popLast() : null;
            }
        } while (null == object && System.currentTimeMillis() < end);
        if (null == object) {
            throw new PoolException("Could not acquire the resource");
        }
        return object;
    }

    private Object popLast() {
        return this.m_buffer.remove(this.m_buffer.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRelease(Object object) {
        if (!this.m_disposed) {
            List list = this.m_buffer;
            synchronized (list) {
                this.m_buffer.add(object);
                this.m_buffer.notify();
            }
        }
        return this.m_disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.m_disposed = true;
        List list = this.m_buffer;
        synchronized (list) {
            while (!this.m_buffer.isEmpty()) {
                this.release(this.popLast());
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "{m_buffer.size()=" + this.m_buffer.size() + '}';
    }

    public long getTimeout() {
        return this.m_timeout;
    }
}

