/*
 * Decompiled with CFR 0.152.
 */
package org.d_haven.mpool;

import java.util.Iterator;
import java.util.List;
import org.d_haven.event.command.RepeatedCommand;
import org.d_haven.mpool.ManagablePool;

public class ManagePoolsCommand
implements RepeatedCommand {
    private static final long DELAY_INTERVAL = 10000L;
    private static final int DEFAULT_MAX = 256;
    private final List m_pools;
    private final int m_min = 4;
    private final int m_max = 256;
    private final int m_grow = 4;

    public ManagePoolsCommand(List pools) {
        this.m_pools = pools;
    }

    public long getDelayInterval() {
        return 10000L;
    }

    public long getRepeatInterval() {
        return 10000L;
    }

    public int getNumberOfRepeats() {
        return -1;
    }

    public void execute() throws Exception {
        Iterator i = this.m_pools.iterator();
        while (i.hasNext()) {
            ManagablePool pool = (ManagablePool)i.next();
            int size = pool.size();
            if (4 > size) {
                pool.grow(4);
            }
            if (256 >= size) continue;
            pool.shrink(4);
        }
    }

    public String toString() {
        return this.getClass().getName() + "{m_pools=" + this.m_pools + '}';
    }
}

