/*
 * Decompiled with CFR 0.152.
 */
package org.d_haven.mpool;

import java.lang.reflect.Method;
import org.d_haven.mpool.RecyclePolicy;

public class ReflectionRecyclePolicy
implements RecyclePolicy {
    private final String m_methodName;
    private static final Class[] EMPTY_PARAM_DEFS = new Class[0];
    private static final Object[] EMPTY_PARAMS = new Object[0];

    public ReflectionRecyclePolicy(String methodName) {
        if (null == methodName) {
            throw new IllegalArgumentException("'methodName' must be provided.");
        }
        this.m_methodName = methodName;
    }

    public void recycle(Object pooledObject) {
        Class<?> klass = pooledObject.getClass();
        try {
            Method meth = klass.getMethod(this.m_methodName, EMPTY_PARAM_DEFS);
            meth.invoke(pooledObject, EMPTY_PARAMS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.getClass().getName() + "{m_methodName='" + this.m_methodName + "'}";
    }
}

