/*
 * Decompiled with CFR 0.152.
 */
package org.d_haven.mpool;

import java.util.LinkedList;
import org.d_haven.mpool.AbstractPool;
import org.d_haven.mpool.ManagablePool;
import org.d_haven.mpool.ObjectFactory;

public final class VariableSizePool
extends AbstractPool
implements ManagablePool {
    private boolean m_disposed = false;
    private final LinkedList m_buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableSizePool(ObjectFactory factory, int size) throws Exception {
        super(factory);
        if (0 > size) {
            throw new IllegalArgumentException("'size' should zero or greater");
        }
        this.m_buffer = new LinkedList();
        LinkedList linkedList = this.m_buffer;
        synchronized (linkedList) {
            for (int i = 0; i < size; ++i) {
                this.m_buffer.add(this.newInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doAcquire() throws Exception {
        if (this.m_disposed) {
            throw new IllegalStateException("Cannot get an object from a disposed pool");
        }
        Object object = null;
        LinkedList linkedList = this.m_buffer;
        synchronized (linkedList) {
            if (0 < this.m_buffer.size()) {
                object = this.popLast();
            }
        }
        if (null == object) {
            object = this.newInstance();
        }
        return object;
    }

    private Object popLast() {
        Object object = this.m_buffer.remove(this.m_buffer.size() - 1);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRelease(Object pooledObject) {
        if (!this.m_disposed) {
            LinkedList linkedList = this.m_buffer;
            synchronized (linkedList) {
                this.m_buffer.add(pooledObject);
            }
        }
        return this.m_disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.m_disposed = true;
        LinkedList linkedList = this.m_buffer;
        synchronized (linkedList) {
            while (!this.m_buffer.isEmpty()) {
                this.release(this.popLast());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink(int byNum) {
        LinkedList linkedList = this.m_buffer;
        synchronized (linkedList) {
            int num = Math.min(byNum, this.m_buffer.size());
            for (int i = 0; i < num; ++i) {
                this.disposeInstance(this.popLast());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grow(int byNum) {
        LinkedList linkedList = this.m_buffer;
        synchronized (linkedList) {
            for (int i = 0; i < byNum; ++i) {
                try {
                    this.m_buffer.add(this.newInstance());
                    continue;
                }
                catch (Exception e) {
                    this.fireCreationFailedEvent(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.m_buffer;
        synchronized (linkedList) {
            return this.m_buffer.size();
        }
    }

    public String toString() {
        return this.getClass().getName() + "{m_buffer.size()=" + this.m_buffer.size() + '}';
    }
}

