/*
 * Decompiled with CFR 0.152.
 */
package dalma.endpoints.jbi;

import dalma.endpoints.jbi.JBIException;
import dalma.endpoints.jbi.MessageExchangeHandler;
import dalma.endpoints.jbi.ReceiverThread;
import dalma.spi.port.MultiplexedEndPoint;
import java.util.logging.Level;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIEndPoint
extends MultiplexedEndPoint<String, MessageExchange> {
    private final DeliveryChannel channel;
    private MessageExchangeHandler meHandler;
    private Thread receiverThread;

    public JBIEndPoint(String name, DeliveryChannel channel) {
        super(name);
        this.channel = channel;
        this.receiverThread = new ReceiverThread(this, channel);
    }

    protected String getKey(MessageExchange msg) {
        return msg.getExchangeId();
    }

    protected void onNewMessage(MessageExchange msg) {
        MessageExchangeHandler h = this.meHandler;
        if (h != null) {
            try {
                h.onNewMessage(msg);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    protected String send(MessageExchange msg) {
        try {
            this.channel.send(msg);
            return msg.getExchangeId();
        }
        catch (MessagingException e) {
            throw new JBIException(e);
        }
    }

    protected void start() {
        this.receiverThread.start();
    }

    protected void stop() {
        this.receiverThread.interrupt();
        try {
            this.receiverThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.channel.close();
        }
        catch (MessagingException e) {
            throw new JBIException(e);
        }
    }

    public MessageExchangeHandler getMessageExchangeHandler() {
        return this.meHandler;
    }

    public void setMessageExchangeHandler(MessageExchangeHandler meHandler) {
        this.meHandler = meHandler;
    }
}

