/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal;

import de.aaschmid.gradle.plugins.cpd.Cpd;
import de.aaschmid.gradle.plugins.cpd.CpdCsvFileReport;
import de.aaschmid.gradle.plugins.cpd.CpdReports;
import de.aaschmid.gradle.plugins.cpd.CpdTextFileReport;
import de.aaschmid.gradle.plugins.cpd.CpdXmlFileReport;
import de.aaschmid.gradle.plugins.cpd.internal.CpdXmlFileReportImpl;
import java.lang.reflect.Field;
import java.util.List;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.FileReporter;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.ReportException;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.reporting.SingleFileReport;

public class CpdReporter {
    private static final Logger logger = Logging.getLogger(CpdReporter.class);
    private final String encoding;
    private final SingleFileReport report;

    public CpdReporter(Cpd task) {
        if (task == null) {
            throw new NullPointerException("task must not be null");
        }
        if (task.getEncoding() == null) {
            throw new InvalidUserDataException(String.format("Task '%s' requires encoding but was: %s.", task.getName(), task.getEncoding()));
        }
        CpdReports reports = task.getReports();
        if (reports.getEnabled().size() != 1) {
            throw new InvalidUserDataException(String.format("Task '%s' requires exactly one report to be enabled but was: %s.", task.getName(), reports.getEnabled().getAsMap().keySet()));
        }
        this.encoding = task.getEncoding();
        this.report = (SingleFileReport)reports.getEnabled().iterator().next();
        try {
            this.report.getDestination();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserDataException(String.format("'%s' requires valid destination but was 'null'.", this.report));
        }
    }

    public void generate(List<Match> matches) {
        if (logger.isInfoEnabled()) {
            logger.info("Generating report");
        }
        String renderedMatches = this.createRendererFor(this.report).render(matches.iterator());
        FileReporter reporter = new FileReporter(this.report.getDestination(), this.encoding);
        try {
            reporter.report(renderedMatches);
        }
        catch (ReportException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    public Renderer createRendererFor(SingleFileReport report) {
        if (report instanceof CpdCsvFileReport) {
            char separator = ((CpdCsvFileReport)report).getSeparator().charValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating renderer to generate CSV file separated by '{}'.", (Object)Character.valueOf(separator));
            }
            return new CSVRenderer(separator);
        }
        if (report instanceof CpdTextFileReport) {
            String lineSeparator = ((CpdTextFileReport)report).getLineSeparator();
            boolean trimLeadingCommonSourceWhitespaces = ((CpdTextFileReport)report).getTrimLeadingCommonSourceWhitespaces();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating renderer to generate simple text file separated by '{}' and trimmed '{}'.", (Object)lineSeparator, (Object)trimLeadingCommonSourceWhitespaces);
            }
            SimpleRenderer result = new SimpleRenderer(lineSeparator);
            this.setTrimLeadingWhitespacesByReflection((Renderer)result, trimLeadingCommonSourceWhitespaces);
            return result;
        }
        if (report instanceof CpdXmlFileReport) {
            String encoding = ((CpdXmlFileReportImpl)report).getXmlRendererEncoding();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating renderer to generate XML file with encoding '{}'.", (Object)encoding);
            }
            return new XMLRenderer(encoding);
        }
        throw new GradleException(String.format("Cannot create report for unsupported %s", report.getClass().getCanonicalName()));
    }

    private void setTrimLeadingWhitespacesByReflection(Renderer result, boolean trimLeadingCommonSourceWhitespaces) {
        block3: {
            String fieldName = "trimLeadingWhitespace";
            if (logger.isDebugEnabled()) {
                logger.debug("Try setting '{}' field to '{}' for '{}' by reflection.", new Object[]{fieldName, trimLeadingCommonSourceWhitespaces, result});
            }
            try {
                Field field = SimpleRenderer.class.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(result, trimLeadingCommonSourceWhitespaces);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn(String.format("Could not set field '%s' on created SimpleRenderer by reflection due to:", fieldName), (Throwable)e);
            }
        }
    }
}

