/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd;

import de.aaschmid.gradle.plugins.cpd.CpdCsvFileReport;
import de.aaschmid.gradle.plugins.cpd.CpdReports;
import de.aaschmid.gradle.plugins.cpd.CpdTextFileReport;
import de.aaschmid.gradle.plugins.cpd.CpdXmlFileReport;
import de.aaschmid.gradle.plugins.cpd.internal.CpdReportsImpl;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdAction;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdExecutionConfiguration;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdReportConfiguration;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.DeprecationLogger;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class Cpd
extends SourceTask
implements VerificationTask,
Reporting<CpdReports> {
    private static final Logger logger = Logging.getLogger(Cpd.class);
    private final WorkerExecutor workerExecutor;
    private final CpdReportsImpl reports;
    private String encoding;
    private boolean ignoreAnnotations;
    private boolean ignoreFailures;
    private boolean ignoreIdentifiers;
    private boolean ignoreLiterals;
    private String language;
    private int minimumTokenCount;
    private FileCollection pmdClasspath;
    private boolean skipDuplicateFiles;
    private boolean skipLexicalErrors;
    private boolean skipBlocks;
    private String skipBlocksPattern;

    @Inject
    public Cpd(Instantiator instantiator, WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.reports = (CpdReportsImpl)DeprecationLogger.whileDisabled(() -> (CpdReportsImpl)instantiator.newInstance(CpdReportsImpl.class, new Object[]{this}));
    }

    @TaskAction
    public void run() {
        this.checkTaskState();
        this.workerExecutor.submit(CpdAction.class, config -> {
            config.setClasspath((Iterable)this.getPmdClasspath());
            config.setDisplayName("CPD worker");
            config.setParams(new Object[]{this.createCpdExecutionConfiguration(), this.createCpdReportConfigurations()});
        });
    }

    private void checkTaskState() {
        if (this.getEncoding() == null) {
            throw new InvalidUserDataException(String.format("Task '%s' requires 'encoding' but was: %s.", this.getName(), this.getEncoding()));
        }
        if (this.getMinimumTokenCount() <= 0) {
            throw new InvalidUserDataException(String.format("Task '%s' requires 'minimumTokenCount' to be greater than zero.", this.getName()));
        }
        if (this.reports.getEnabled().isEmpty()) {
            throw new InvalidUserDataException(String.format("Task '%s' requires at least one enabled report.", this.getName()));
        }
    }

    private CpdExecutionConfiguration createCpdExecutionConfiguration() {
        return new CpdExecutionConfiguration(this.getEncoding(), this.getIgnoreAnnotations(), this.getIgnoreFailures(), this.getIgnoreIdentifiers(), this.getIgnoreLiterals(), this.getLanguage(), this.getMinimumTokenCount(), this.getSkipBlocks(), this.getSkipBlocksPattern(), this.getSkipDuplicateFiles(), this.getSkipLexicalErrors(), this.getSource().getFiles());
    }

    private List<CpdReportConfiguration> createCpdReportConfigurations() {
        ArrayList<CpdReportConfiguration> result = new ArrayList<CpdReportConfiguration>();
        Iterator iterator = this.getReports().iterator();
        while (iterator.hasNext()) {
            Report report = (Report)iterator.next();
            if (!report.isEnabled()) continue;
            if (report instanceof CpdCsvFileReport) {
                Character separator = ((CpdCsvFileReport)report).getSeparator();
                result.add(new CpdReportConfiguration.CpdCsvReport(this.getEncoding(), report.getDestination(), separator));
                continue;
            }
            if (report instanceof CpdTextFileReport) {
                String lineSeparator = ((CpdTextFileReport)report).getLineSeparator();
                boolean trimLeadingCommonSourceWhitespaces = ((CpdTextFileReport)report).getTrimLeadingCommonSourceWhitespaces();
                result.add(new CpdReportConfiguration.CpdTextReport(this.getEncoding(), report.getDestination(), lineSeparator, trimLeadingCommonSourceWhitespaces));
                continue;
            }
            if (report instanceof CpdXmlFileReport) {
                String encoding = this.getXmlRendererEncoding((CpdXmlFileReport)report);
                result.add(new CpdReportConfiguration.CpdXmlReport(encoding, report.getDestination()));
                continue;
            }
            throw new IllegalArgumentException(String.format("Report of type '%s' not available.", report.getClass().getSimpleName()));
        }
        return result;
    }

    String getXmlRendererEncoding(CpdXmlFileReport report) {
        String encoding = report.getEncoding();
        if (encoding == null) {
            encoding = this.getEncoding();
        }
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return encoding;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    public CpdReports reports(Closure closure) {
        return (CpdReports)this.reports.configure(closure);
    }

    @Nested
    public CpdReports getReports() {
        return this.reports;
    }

    public CpdReports reports(Action<? super CpdReports> action) {
        action.execute((Object)this.reports);
        return this.reports;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    public boolean getIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public boolean getIgnoreIdentifiers() {
        return this.ignoreIdentifiers;
    }

    public void setIgnoreIdentifiers(boolean ignoreIdentifiers) {
        this.ignoreIdentifiers = ignoreIdentifiers;
    }

    @Input
    public boolean getIgnoreLiterals() {
        return this.ignoreLiterals;
    }

    public void setIgnoreLiterals(boolean ignoreLiterals) {
        this.ignoreLiterals = ignoreLiterals;
    }

    @Input
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Input
    public int getMinimumTokenCount() {
        return this.minimumTokenCount;
    }

    public void setMinimumTokenCount(int minimumTokenCount) {
        this.minimumTokenCount = minimumTokenCount;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileCollection getPmdClasspath() {
        return this.pmdClasspath;
    }

    public void setPmdClasspath(FileCollection pmdClasspath) {
        this.pmdClasspath = pmdClasspath;
    }

    @Input
    public boolean getSkipDuplicateFiles() {
        return this.skipDuplicateFiles;
    }

    public void setSkipDuplicateFiles(boolean skipDuplicateFiles) {
        this.skipDuplicateFiles = skipDuplicateFiles;
    }

    @Input
    public boolean getSkipLexicalErrors() {
        return this.skipLexicalErrors;
    }

    public void setSkipLexicalErrors(boolean skipLexicalErrors) {
        this.skipLexicalErrors = skipLexicalErrors;
    }

    @Input
    public boolean getSkipBlocks() {
        return this.skipBlocks;
    }

    public void setSkipBlocks(boolean skipBlocks) {
        this.skipBlocks = skipBlocks;
    }

    @Input
    public String getSkipBlocksPattern() {
        return this.skipBlocksPattern;
    }

    public void setSkipBlocksPattern(String skipBlocksPattern) {
        this.skipBlocksPattern = skipBlocksPattern;
    }
}

