/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd;

import de.aaschmid.gradle.plugins.cpd.Cpd;
import de.aaschmid.gradle.plugins.cpd.CpdExtension;
import java.io.File;
import java.util.Collections;
import java.util.Optional;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

@Incubating
public class CpdPlugin
implements Plugin<Project> {
    private static final Logger logger = Logging.getLogger(CpdPlugin.class);
    private static final String TASK_NAME_CPD_CHECK = "cpdCheck";

    public void apply(Project project) {
        project.getPlugins().apply(ReportingBasePlugin.class);
        CpdExtension extension = this.createExtension(project);
        this.createConfiguration(project, extension);
        this.setupTaskDefaults(project, extension);
        TaskProvider taskProvider = project.getTasks().register(TASK_NAME_CPD_CHECK, Cpd.class, task -> {
            task.setDescription("Run CPD analysis for all sources");
            project.getAllprojects().forEach(p -> p.getPlugins().withType(JavaBasePlugin.class, plugin -> ((JavaPluginConvention)p.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> sourceSet.getAllJava().getSrcDirs().forEach(xva$0 -> task.source(new Object[]{xva$0})))));
        });
        project.getPlugins().withType(LifecycleBasePlugin.class, plugin -> ((Task)project.getTasks().findByName("check")).dependsOn(new Object[]{taskProvider}));
        project.getGradle().getTaskGraph().whenReady(graph -> {
            Optional<Task> lastCheckTask;
            String projectPath;
            String string = projectPath = project.getRootProject() == project ? project.getPath() : project.getPath() + ":";
            if (!graph.hasTask(projectPath + TASK_NAME_CPD_CHECK) && logger.isWarnEnabled() && (lastCheckTask = graph.getAllTasks().stream().sorted(Collections.reverseOrder()).filter(t -> t.getName().endsWith("check")).findFirst()).isPresent()) {
                Task task = lastCheckTask.get();
                String message = "\nWARNING: Due to the absence of '" + LifecycleBasePlugin.class.getSimpleName() + "' on " + project + " the task ':" + TASK_NAME_CPD_CHECK + "' could not be added to task graph. Therefore CPD will not be executed. To prevent this, manually add a task dependency of ':" + TASK_NAME_CPD_CHECK + "' to a '" + "check" + "' task of a subproject.\n1) Directly to " + task.getProject() + ":\n    " + task.getName() + ".dependsOn(':" + TASK_NAME_CPD_CHECK + "')\n2) Indirectly, e.g. via " + project + ":\n    project('" + task.getProject().getPath() + "') {\n        plugins.withType(LifecycleBasePlugin) { // <- just required if 'java' plugin is applied within subproject\n            " + task.getName() + ".dependsOn(" + TASK_NAME_CPD_CHECK + ")\n        }\n    }\n";
                logger.warn(message);
            }
        });
    }

    private CpdExtension createExtension(Project project) {
        CpdExtension extension = (CpdExtension)((Object)project.getExtensions().create("cpd", CpdExtension.class, new Object[0]));
        extension.setToolVersion("6.14.0");
        return extension;
    }

    private void setupTaskDefaults(Project project, CpdExtension extension) {
        project.getTasks().withType(Cpd.class).configureEach(task -> {
            ConventionMapping taskMapping = task.getConventionMapping();
            taskMapping.map("encoding", extension::getEncoding);
            taskMapping.map("ignoreAnnotations", extension::isIgnoreAnnotations);
            taskMapping.map("ignoreIdentifiers", extension::isIgnoreIdentifiers);
            taskMapping.map("ignoreFailures", () -> ((CpdExtension)extension).isIgnoreFailures());
            taskMapping.map("ignoreLiterals", extension::isIgnoreLiterals);
            taskMapping.map("language", extension::getLanguage);
            taskMapping.map("minimumTokenCount", extension::getMinimumTokenCount);
            taskMapping.map("pmdClasspath", () -> (Configuration)project.getConfigurations().findByName("cpd"));
            taskMapping.map("skipDuplicateFiles", extension::isSkipDuplicateFiles);
            taskMapping.map("skipLexicalErrors", extension::isSkipLexicalErrors);
            taskMapping.map("skipBlocks", extension::isSkipBlocks);
            taskMapping.map("skipBlocksPattern", extension::getSkipBlocksPattern);
            ConventionMapping extensionMapping = ((IConventionAware)extension).getConventionMapping();
            extensionMapping.map("reportsDir", () -> ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).file("cpd"));
            task.getReports().all(report -> {
                ConventionMapping reportMapping = ((IConventionAware)report).getConventionMapping();
                reportMapping.map("enabled", () -> "xml".equals(report.getName()));
                reportMapping.map("destination", () -> new File(extension.getReportsDir(), task.getName() + "." + report.getName()));
            });
        });
    }

    private void createConfiguration(Project project, CpdExtension extension) {
        Configuration configuration = (Configuration)project.getConfigurations().create("cpd");
        configuration.setDescription("The CPD libraries to be used for this project.");
        configuration.setTransitive(true);
        configuration.setVisible(false);
        configuration.defaultDependencies(d -> d.add((Object)project.getDependencies().create((Object)("net.sourceforge.pmd:pmd-dist:" + extension.getToolVersion()))));
    }
}

