/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.domain;

import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.domain.ReadStorePassword;
import org.adorsys.encobject.exceptions.KeyStoreAuthException;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;

public class KeyStoreAuth {
    private ReadStorePassword readStorePassword;
    private ReadKeyPassword readKeyPassword;

    public KeyStoreAuth(ReadStorePassword readStorePassword, ReadKeyPassword readKeyPassword) {
        this.readStorePassword = readStorePassword;
        this.readKeyPassword = readKeyPassword;
    }

    public CallbackHandler getReadStoreHandler() {
        if (this.readStorePassword == null) {
            throw new KeyStoreAuthException("Access to READ STORE HANDLER not allowed.");
        }
        return new PasswordCallbackHandler(this.readStorePassword.getValue().toCharArray());
    }

    public CallbackHandler getReadKeyHandler() {
        if (this.readKeyPassword == null) {
            throw new KeyStoreAuthException("Access to READ KEY HANDLER not allowed.");
        }
        return new PasswordCallbackHandler(this.readKeyPassword.getValue().toCharArray());
    }

    public ReadStorePassword getReadStorePassword() {
        if (this.readStorePassword == null) {
            throw new KeyStoreAuthException("Access to READ STORE PASSWORD not allowed.");
        }
        return this.readStorePassword;
    }

    public ReadKeyPassword getReadKeyPassword() {
        if (this.readKeyPassword == null) {
            throw new KeyStoreAuthException("Access to READ KEY PASSWORD not allowed");
        }
        return this.readKeyPassword;
    }

    public void setReadKeyPassword(ReadKeyPassword readKeyPassword) {
        this.readKeyPassword = readKeyPassword;
    }

    public String toString() {
        return "KeyStoreAuth{" + (Object)((Object)this.readStorePassword) + ", " + (Object)((Object)this.readKeyPassword) + '}';
    }
}

