/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.domain.ObjectHandle;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.domain.StorageMetadata;
import de.adorsys.dfs.connection.api.domain.UserMetaData;
import de.adorsys.dfs.connection.api.service.api.ExtendedStoreConnection;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.dfs.connection.api.service.impl.SimpleStorageMetadataImpl;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.Tuple;
import org.adorsys.encobject.service.api.KeystorePersistence;
import org.adorsys.jkeygen.keystore.KeyStoreService;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreKeystorePersistenceImpl
implements KeystorePersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreKeystorePersistenceImpl.class);
    private static final String KEYSTORE_TYPE_KEY = "INTERNAL_BLOB_STORE_KEYSTORE_PERSISTENCE_TYPE_KEY";
    private ExtendedStoreConnection extendedStoreConnection;

    public BlobStoreKeystorePersistenceImpl(ExtendedStoreConnection extendedStoreConnection) {
        this.extendedStoreConnection = extendedStoreConnection;
    }

    @Override
    public void saveKeyStore(KeyStore keystore, CallbackHandler storePassHandler, ObjectHandle handle) {
        String storeType = keystore.getType();
        byte[] bs = KeyStoreService.toByteArray((KeyStore)keystore, (String)handle.getName(), (CallbackHandler)storePassHandler);
        BucketPath bucketPath = BucketPath.fromHandle((ObjectHandle)handle);
        SimplePayloadImpl payload = new SimplePayloadImpl(bs);
        payload.getStorageMetadata().getUserMetadata().put(KEYSTORE_TYPE_KEY, storeType);
        this.extendedStoreConnection.putBlob(bucketPath, (Payload)payload);
    }

    @Override
    public void saveKeyStoreWithAttributes(KeyStore keystore, UserMetaData userMetaData, CallbackHandler storePassHandler, ObjectHandle handle) {
        String storeType = keystore.getType();
        byte[] bs = KeyStoreService.toByteArray((KeyStore)keystore, (String)handle.getName(), (CallbackHandler)storePassHandler);
        BucketPath bucketPath = BucketPath.fromHandle((ObjectHandle)handle);
        SimpleStorageMetadataImpl simpleStorageMetadataImpl = new SimpleStorageMetadataImpl();
        simpleStorageMetadataImpl.getUserMetadata().put(KEYSTORE_TYPE_KEY, storeType);
        simpleStorageMetadataImpl.addUserMetadata(userMetaData);
        SimplePayloadImpl payload = new SimplePayloadImpl((StorageMetadata)simpleStorageMetadataImpl, bs);
        this.extendedStoreConnection.putBlob(bucketPath, (Payload)payload);
    }

    @Override
    public KeyStore loadKeystore(ObjectHandle handle, CallbackHandler handler) {
        BucketPath bucketPath = BucketPath.fromHandle((ObjectHandle)handle);
        Payload payload = this.extendedStoreConnection.getBlob(bucketPath);
        return this.initKeystore(payload, handle.getName(), handler);
    }

    @Override
    public Tuple<KeyStore, Map<String, String>> loadKeystoreAndAttributes(ObjectHandle handle, CallbackHandler handler) {
        BucketPath bucketPath = BucketPath.fromHandle((ObjectHandle)handle);
        Payload payload = this.extendedStoreConnection.getBlob(bucketPath);
        KeyStore keyStore = this.initKeystore(payload, handle.getName(), handler);
        UserMetaData metaInfo = payload.getStorageMetadata().getUserMetadata();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        Set keySet = metaInfo.keySet();
        for (String key : keySet) {
            attributeMap.put(key, metaInfo.get(key));
        }
        attributeMap.remove(KEYSTORE_TYPE_KEY);
        return new Tuple<KeyStore, Map<String, String>>(keyStore, attributeMap);
    }

    @Override
    public boolean hasKeystore(ObjectHandle handle) {
        return this.extendedStoreConnection.blobExists(BucketPath.fromHandle((ObjectHandle)handle));
    }

    private KeyStore initKeystore(Payload payload, String storeid, CallbackHandler handler) {
        KeyStoreType keyStoreType = new KeyStoreType(payload.getStorageMetadata().getUserMetadata().get(KEYSTORE_TYPE_KEY));
        return KeyStoreService.loadKeyStore((byte[])payload.getData(), (String)storeid, (KeyStoreType)keyStoreType, (CallbackHandler)handler);
    }
}

