/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.HexUtil;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.service.api.ExtendedStoreConnection;
import java.security.KeyStore;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.KeyStoreAuth;
import org.adorsys.encobject.exceptions.KeyStoreExistsException;
import org.adorsys.encobject.service.api.KeyStoreService;
import org.adorsys.encobject.service.api.KeystorePersistence;
import org.adorsys.encobject.service.api.generator.KeyStoreCreationConfig;
import org.adorsys.encobject.service.impl.BlobStoreKeystorePersistenceImpl;
import org.adorsys.encobject.service.impl.generator.KeyStoreCreationConfigImpl;
import org.adorsys.encobject.service.impl.generator.KeyStoreGenerator;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreServiceImpl
implements KeyStoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreServiceImpl.class);
    private KeystorePersistence keystorePersistence;
    private ExtendedStoreConnection extendedStoreConnection;

    public KeyStoreServiceImpl(ExtendedStoreConnection extendedStoreConnection) {
        this.keystorePersistence = new BlobStoreKeystorePersistenceImpl(extendedStoreConnection);
        this.extendedStoreConnection = extendedStoreConnection;
    }

    @Override
    public void createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType, BucketPath keyStorePath, KeyStoreCreationConfig config) {
        try {
            LOGGER.debug("start create keystore " + keyStorePath);
            if (this.extendedStoreConnection.blobExists(keyStorePath)) {
                throw new KeyStoreExistsException("creation of keytore aborted. a keystore already exists in " + keyStorePath);
            }
            if (config == null) {
                config = new KeyStoreCreationConfigImpl(5, 5, 5);
            }
            String serverKeyPairAliasPrefix = HexUtil.convertBytesToHexString((byte[])keyStorePath.getObjectHandle().getName().getBytes());
            LOGGER.debug("keystoreid = " + serverKeyPairAliasPrefix);
            String realKeyStoreId = new String(HexUtil.convertHexStringToBytes((String)serverKeyPairAliasPrefix));
            LOGGER.debug("meaning of keystoreid = " + realKeyStoreId);
            KeyStoreGenerator keyStoreGenerator = new KeyStoreGenerator(config, keyStoreType, serverKeyPairAliasPrefix, keyStoreAuth.getReadKeyPassword());
            KeyStore userKeyStore = keyStoreGenerator.generate();
            this.keystorePersistence.saveKeyStore(userKeyStore, keyStoreAuth.getReadStoreHandler(), keyStorePath.getObjectHandle());
            LOGGER.debug("finished create keystore " + keyStorePath);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public KeyStore loadKeystore(BucketPath keyStorePath, CallbackHandler userKeystoreHandler) {
        LOGGER.debug("start load keystore " + keyStorePath);
        KeyStore keyStore = this.keystorePersistence.loadKeystore(keyStorePath.getObjectHandle(), userKeystoreHandler);
        LOGGER.debug("finished load keystore " + keyStorePath);
        return keyStore;
    }
}

