/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jjwk.keystore;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.PasswordLookup;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.apache.commons.lang3.RandomUtils;

public class JwkExport {
    public static List<JWK> selectSignKeys(JWKSet exportKeys) {
        JWKMatcher signKeys = new JWKMatcher.Builder().keyUse(KeyUse.SIGNATURE).build();
        return new JWKSelector(signKeys).select(exportKeys);
    }

    public static JWKSet exportPublicKeys(JWKSet exportKeys) {
        return exportKeys.toPublicJWKSet();
    }

    public static List<JWK> selectKeypairs(JWKSet exportKeys) {
        JWKSet publicJWKSet = exportKeys.toPublicJWKSet();
        List keys = publicJWKSet.getKeys();
        if (keys == null || keys.isEmpty()) {
            return keys;
        }
        HashSet<String> keyIds = new HashSet<String>();
        for (JWK jwk : keys) {
            keyIds.add(jwk.getKeyID());
        }
        JWKMatcher keyPairs = new JWKMatcher.Builder().keyIDs(keyIds).build();
        return new JWKSelector(keyPairs).select(exportKeys);
    }

    public static JWK selectKey(JWKSet exportKeys, String keyId) {
        JWKMatcher matcher = new JWKMatcher.Builder().keyID(keyId).build();
        List keys = new JWKSelector(matcher).select(exportKeys);
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        return (JWK)keys.iterator().next();
    }

    public static JWKSet exportKeys(KeyStore keyStore, final CallbackHandler callbackHandler) {
        PasswordLookup pwLookup = new PasswordLookup(){

            public char[] lookupPassword(String name) {
                return PasswordCallbackUtils.getPassword((CallbackHandler)callbackHandler, (String)name);
            }
        };
        try {
            return JWKSet.load((KeyStore)keyStore, (PasswordLookup)pwLookup);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JWK randomKey(List<JWK> keys) {
        int nextInt = RandomUtils.nextInt((int)0, (int)keys.size());
        return keys.get(nextInt);
    }
}

