/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jjwk.selector;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jca.JCASupport;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import java.util.LinkedHashSet;
import org.adorsys.jjwk.selector.JWSSignerAndAlgorithm;

public class JWSSignerAndAlgorithmBuilder {
    public static JWSSignerAndAlgorithm build(JWK jwk) {
        return JWSSignerAndAlgorithmBuilder.build(jwk, null);
    }

    public static JWSSignerAndAlgorithm build(JWK jwk, LinkedHashSet<JWSAlgorithm> algoPrefs) {
        RSASSASigner signer = null;
        JWSAlgorithm jwsAlgorithm = null;
        try {
            Algorithm alg = jwk.getAlgorithm();
            if (alg != null) {
                if (alg instanceof JWSAlgorithm) {
                    jwsAlgorithm = (JWSAlgorithm)alg;
                } else {
                    throw new IllegalArgumentException("Provided JWK does not contain an algoritm");
                }
            }
            if (jwk instanceof RSAKey) {
                if (algoPrefs == null) {
                    algoPrefs = JWSAlgorithm.Family.RSA;
                }
                if ((jwsAlgorithm = JWSSignerAndAlgorithmBuilder.selectAlgoPref(JWSAlgorithm.Family.RSA, (LinkedHashSet<JWSAlgorithm>)algoPrefs)) != null) {
                    signer = new RSASSASigner((RSAKey)jwk);
                }
            } else if (jwk instanceof ECKey) {
                if (algoPrefs == null) {
                    algoPrefs = JWSAlgorithm.Family.EC;
                }
                if ((jwsAlgorithm = JWSSignerAndAlgorithmBuilder.selectAlgoPref(JWSAlgorithm.Family.EC, (LinkedHashSet<JWSAlgorithm>)algoPrefs)) != null) {
                    signer = new ECDSASigner((ECKey)jwk);
                }
            } else if (jwk instanceof OctetSequenceKey) {
                if (algoPrefs == null) {
                    algoPrefs = JWSAlgorithm.Family.HMAC_SHA;
                }
                if ((jwsAlgorithm = JWSSignerAndAlgorithmBuilder.selectAlgoPref(JWSAlgorithm.Family.HMAC_SHA, (LinkedHashSet<JWSAlgorithm>)algoPrefs)) != null) {
                    signer = new MACSigner((OctetSequenceKey)jwk);
                }
            } else {
                throw new IllegalStateException("Key provided is not a signature key. Key must be of type JWS RSAKey or ECKey or OctetSequenceKey");
            }
            if (signer == null) {
                throw new IllegalStateException("Key provided is not an assymetric key. This framwork consumes either RSA od DSA keys.");
            }
        }
        catch (JOSEException ex) {
            throw new IllegalStateException(ex);
        }
        return new JWSSignerAndAlgorithm((JWSSigner)signer, jwsAlgorithm);
    }

    private static JWSAlgorithm selectAlgoPref(JWSAlgorithm.Family family, LinkedHashSet<JWSAlgorithm> algoPrefs) {
        for (JWSAlgorithm algPref : algoPrefs) {
            if (!family.contains((Object)algPref) || !JCASupport.isSupported((JWSAlgorithm)algPref)) continue;
            return algPref;
        }
        return null;
    }
}

