/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jjwk.serverkey;

import com.nimbusds.jose.jwk.AssymetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.SecretJWK;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adorsys.jjwk.serverkey.KeyAndJwk;
import org.adorsys.jjwk.serverkey.KeyConverter;
import org.apache.commons.lang3.RandomUtils;

public class ServerKeyMap {
    private Map<String, KeyAndJwk> keyMap = new HashMap<String, KeyAndJwk>();
    private List<KeyAndJwk> signKeyList = new ArrayList<KeyAndJwk>();
    private List<KeyAndJwk> encKeyList = new ArrayList<KeyAndJwk>();
    private List<KeyAndJwk> secretKeyList = new ArrayList<KeyAndJwk>();

    public ServerKeyMap(JWKSet jwkSet) {
        List keys = jwkSet.getKeys();
        for (JWK jwk : keys) {
            KeyAndJwk keyAndJwk;
            Key key;
            if (jwk instanceof AssymetricJWK) {
                key = KeyConverter.toPrivateOrSecret(jwk);
                if (key == null || jwk.getKeyID() == null) continue;
                keyAndJwk = new KeyAndJwk(key, jwk);
                this.keyMap.put(jwk.getKeyID(), keyAndJwk);
                if (KeyUse.SIGNATURE.equals((Object)jwk.getKeyUse())) {
                    this.signKeyList.add(keyAndJwk);
                    continue;
                }
                if (!KeyUse.ENCRYPTION.equals((Object)jwk.getKeyUse())) continue;
                this.encKeyList.add(keyAndJwk);
                continue;
            }
            if (!(jwk instanceof SecretJWK) || (key = KeyConverter.toPrivateOrSecret(jwk)) == null || jwk.getKeyID() == null) continue;
            keyAndJwk = new KeyAndJwk(key, jwk);
            this.keyMap.put(jwk.getKeyID(), keyAndJwk);
            this.secretKeyList.add(keyAndJwk);
        }
    }

    private KeyAndJwk get(String keyID) {
        if (keyID == null) {
            return null;
        }
        KeyAndJwk keyAndJwk = this.keyMap.get(keyID);
        if (keyAndJwk == null) {
            return null;
        }
        if (!keyID.equalsIgnoreCase(keyAndJwk.jwk.getKeyID())) {
            return null;
        }
        return keyAndJwk;
    }

    public Key getKey(String keyID) {
        KeyAndJwk keyAndJwk = this.get(keyID);
        if (keyAndJwk == null) {
            return null;
        }
        return keyAndJwk.key;
    }

    public KeyAndJwk randomSignKey() {
        int nextInt = RandomUtils.nextInt((int)0, (int)this.signKeyList.size());
        return this.signKeyList.get(nextInt);
    }

    public KeyAndJwk randomSecretKey() {
        int nextInt = RandomUtils.nextInt((int)0, (int)this.secretKeyList.size());
        return this.secretKeyList.get(nextInt);
    }
}

