/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.DocumentKeyStoreOperationsImpl;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import java.security.Key;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DocumentKeyStoreOperationsImplRuntimeDelegatable
extends DocumentKeyStoreOperationsImpl {
    private final DocumentKeyStoreOperationsImpl delegate;

    @Inject
    public DocumentKeyStoreOperationsImplRuntimeDelegatable(@Nullable OverridesRegistry context, KeyCreationConfig config, GenericKeystoreOperations genericOper, DFSConfig dfsConfig, BucketAccessService access, ProfileRetrievalService profile, StorageWriteService writeService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
        super(config, genericOper, dfsConfig, access, profile, writeService, keystoreCache, keyStoreService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(config, genericOper, dfsConfig, access, profile, writeService, keystoreCache, keyStoreService);
        this.delegate = context != null ? (DocumentKeyStoreOperationsImpl)context.findOverride(DocumentKeyStoreOperationsImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public Key getKey(UserIDAuth forUser, String alias) {
        if (null == this.delegate) {
            return super.getKey(forUser, alias);
        }
        return this.delegate.getKey(forUser, alias);
    }

    @Override
    public Set<String> readAliases(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.readAliases(forUser);
        }
        return this.delegate.readAliases(forUser);
    }

    @Override
    public List<PublicKeyIDWithPublicKey> createAndWriteKeyStore(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.createAndWriteKeyStore(forUser);
        }
        return this.delegate.createAndWriteKeyStore(forUser);
    }

    @Override
    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == this.delegate) {
            super.updateReadKeyPassword(forUser, newPassword);
        } else {
            this.delegate.updateReadKeyPassword(forUser, newPassword);
        }
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, DocumentKeyStoreOperationsImpl> ctorCaptor) {
        context.override(DocumentKeyStoreOperationsImpl.class, args -> (DocumentKeyStoreOperationsImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final KeyCreationConfig config;
        private final GenericKeystoreOperations genericOper;
        private final DFSConfig dfsConfig;
        private final BucketAccessService access;
        private final ProfileRetrievalService profile;
        private final StorageWriteService writeService;
        private final KeyStoreCache keystoreCache;
        private final KeyStoreService keyStoreService;

        private ArgumentsCaptor(KeyCreationConfig config, GenericKeystoreOperations genericOper, DFSConfig dfsConfig, BucketAccessService access, ProfileRetrievalService profile, StorageWriteService writeService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
            this.config = config;
            this.genericOper = genericOper;
            this.dfsConfig = dfsConfig;
            this.access = access;
            this.profile = profile;
            this.writeService = writeService;
            this.keystoreCache = keystoreCache;
            this.keyStoreService = keyStoreService;
        }

        public KeyCreationConfig getConfig() {
            return this.config;
        }

        public GenericKeystoreOperations getGenericOper() {
            return this.genericOper;
        }

        public DFSConfig getDfsConfig() {
            return this.dfsConfig;
        }

        public BucketAccessService getAccess() {
            return this.access;
        }

        public ProfileRetrievalService getProfile() {
            return this.profile;
        }

        public StorageWriteService getWriteService() {
            return this.writeService;
        }

        public KeyStoreCache getKeystoreCache() {
            return this.keystoreCache;
        }

        public KeyStoreService getKeyStoreService() {
            return this.keyStoreService;
        }
    }
}

