/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.resource;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.util.function.Supplier;
import javax.inject.Inject;

@RuntimeDelegate
public class ResourceResolverImpl
implements ResourceResolver {
    private final ProfileRetrievalService profile;
    private final BucketAccessService bucketAccessService;

    @Inject
    public ResourceResolverImpl(ProfileRetrievalService profile, BucketAccessService bucketAccessService) {
        this.profile = profile;
        this.bucketAccessService = bucketAccessService;
    }

    public AbsoluteLocation<PublicResource> resolveRelativeToPublicInbox(UserID userID, PublicResource resource) {
        return this.bucketAccessService.publicAccessFor(userID, this.resolveRelative(resource, () -> this.profile.publicProfile(userID).getInbox()));
    }

    public AbsoluteLocation<PrivateResource> resolveRelativeToPrivateInbox(UserIDAuth userID, PrivateResource resource) {
        return this.bucketAccessService.privateAccessFor(userID, this.resolveRelative(resource, () -> this.profile.privateProfile(userID).getInboxWithFullAccess()));
    }

    public AbsoluteLocation<PrivateResource> resolveRelativeToPrivate(UserIDAuth userID, PrivateResource resource, StorageIdentifier identifier) {
        return this.bucketAccessService.privateAccessFor(userID, this.resolveRelative(resource, () -> (AbsoluteLocation)this.profile.privateProfile(userID).getPrivateStorage().get(identifier)));
    }

    public <T extends ResourceLocation<T>> boolean isAbsolute(T resource) {
        return resource.location().isAbsolute();
    }

    private <T extends ResourceLocation<T>> T resolveRelative(T resource, Supplier<ResourceLocation<T>> resolveTo) {
        if (this.isAbsolute(resource)) {
            return resource;
        }
        return (T)((ResourceLocation)resource.resolveFrom(resolveTo.get()));
    }
}

