package de.adorsys.datasafe.directory.impl.profile.keys;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import javax.annotation.processing.Generated;
import javax.inject.Provider;

@ScopeMetadata
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class DocumentKeyStoreOperationsImpl_Factory implements Factory<DocumentKeyStoreOperationsImpl> {
  private final Provider<KeyCreationConfig> configProvider;

  private final Provider<GenericKeystoreOperations> genericOperProvider;

  private final Provider<DFSConfig> dfsConfigProvider;

  private final Provider<BucketAccessService> accessProvider;

  private final Provider<ProfileRetrievalService> profileProvider;

  private final Provider<StorageWriteService> writeServiceProvider;

  private final Provider<KeyStoreCache> keystoreCacheProvider;

  private final Provider<KeyStoreService> keyStoreServiceProvider;

  public DocumentKeyStoreOperationsImpl_Factory(Provider<KeyCreationConfig> configProvider,
      Provider<GenericKeystoreOperations> genericOperProvider,
      Provider<DFSConfig> dfsConfigProvider, Provider<BucketAccessService> accessProvider,
      Provider<ProfileRetrievalService> profileProvider,
      Provider<StorageWriteService> writeServiceProvider,
      Provider<KeyStoreCache> keystoreCacheProvider,
      Provider<KeyStoreService> keyStoreServiceProvider) {
    this.configProvider = configProvider;
    this.genericOperProvider = genericOperProvider;
    this.dfsConfigProvider = dfsConfigProvider;
    this.accessProvider = accessProvider;
    this.profileProvider = profileProvider;
    this.writeServiceProvider = writeServiceProvider;
    this.keystoreCacheProvider = keystoreCacheProvider;
    this.keyStoreServiceProvider = keyStoreServiceProvider;
  }

  @Override
  public DocumentKeyStoreOperationsImpl get() {
    return newInstance(configProvider.get(), genericOperProvider.get(), dfsConfigProvider.get(), accessProvider.get(), profileProvider.get(), writeServiceProvider.get(), keystoreCacheProvider.get(), keyStoreServiceProvider.get());
  }

  public static DocumentKeyStoreOperationsImpl_Factory create(
      Provider<KeyCreationConfig> configProvider,
      Provider<GenericKeystoreOperations> genericOperProvider,
      Provider<DFSConfig> dfsConfigProvider, Provider<BucketAccessService> accessProvider,
      Provider<ProfileRetrievalService> profileProvider,
      Provider<StorageWriteService> writeServiceProvider,
      Provider<KeyStoreCache> keystoreCacheProvider,
      Provider<KeyStoreService> keyStoreServiceProvider) {
    return new DocumentKeyStoreOperationsImpl_Factory(configProvider, genericOperProvider, dfsConfigProvider, accessProvider, profileProvider, writeServiceProvider, keystoreCacheProvider, keyStoreServiceProvider);
  }

  public static DocumentKeyStoreOperationsImpl newInstance(KeyCreationConfig config,
      GenericKeystoreOperations genericOper, DFSConfig dfsConfig, BucketAccessService access,
      ProfileRetrievalService profile, StorageWriteService writeService,
      KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
    return new DocumentKeyStoreOperationsImpl(config, genericOper, dfsConfig, access, profile, writeService, keystoreCache, keyStoreService);
  }
}
