package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.profile.keys.DocumentKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import jakarta.annotation.Generated;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ProfileUpdatingServiceImplRuntimeDelegatable extends ProfileUpdatingServiceImpl {
    private final ProfileUpdatingServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ProfileUpdatingServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            ProfileStoreService storeService, PrivateKeyService privateKeyService,
            StorageKeyStoreOperations storageKeyStoreOper,
            DocumentKeyStoreOperations keyStoreOper) {
        super(storeService, privateKeyService, storageKeyStoreOper, keyStoreOper);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(storeService, privateKeyService, storageKeyStoreOper, keyStoreOper);
        delegate = context != null ? context.findOverride(ProfileUpdatingServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public void updatePublicProfile(UserIDAuth forUser, UserPublicProfile profile) {
        if (null == delegate) {
            super.updatePublicProfile(forUser, profile);
        } else {
            delegate.updatePublicProfile(forUser, profile);
        }
    }

    @Override
    public void updatePrivateProfile(UserIDAuth forUser, UserPrivateProfile profile) {
        if (null == delegate) {
            super.updatePrivateProfile(forUser, profile);
        } else {
            delegate.updatePrivateProfile(forUser, profile);
        }
    }

    @Override
    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == delegate) {
            super.updateReadKeyPassword(forUser, newPassword);
        } else {
            delegate.updateReadKeyPassword(forUser, newPassword);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ProfileUpdatingServiceImpl> ctorCaptor) {
        context.override(ProfileUpdatingServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final ProfileStoreService storeService;

        private final PrivateKeyService privateKeyService;

        private final StorageKeyStoreOperations storageKeyStoreOper;

        private final DocumentKeyStoreOperations keyStoreOper;

        private ArgumentsCaptor(ProfileStoreService storeService,
                PrivateKeyService privateKeyService, StorageKeyStoreOperations storageKeyStoreOper,
                DocumentKeyStoreOperations keyStoreOper) {
            this.storeService = storeService;
            this.privateKeyService = privateKeyService;
            this.storageKeyStoreOper = storageKeyStoreOper;
            this.keyStoreOper = keyStoreOper;
        }

        public ProfileStoreService getStoreService() {
            return storeService;
        }

        public PrivateKeyService getPrivateKeyService() {
            return privateKeyService;
        }

        public StorageKeyStoreOperations getStorageKeyStoreOper() {
            return storageKeyStoreOper;
        }

        public DocumentKeyStoreOperations getKeyStoreOper() {
            return keyStoreOper;
        }
    }
}
