/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.PublicKeyService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.inject.Inject;

@RuntimeDelegate
public class DFSPublicKeyServiceImpl
implements PublicKeyService {
    private final KeyStoreCache keystoreCache;
    private final BucketAccessService bucketAccessService;
    private final ProfileRetrievalService profiles;
    private final StorageReadService readService;
    private final GsonSerde serde;

    @Inject
    public DFSPublicKeyServiceImpl(KeyStoreCache keystoreCache, BucketAccessService bucketAccessService, ProfileRetrievalService profiles, StorageReadService readService, GsonSerde serde) {
        this.keystoreCache = keystoreCache;
        this.bucketAccessService = bucketAccessService;
        this.profiles = profiles;
        this.readService = readService;
        this.serde = serde;
    }

    public PublicKeyIDWithPublicKey publicKey(UserID forUser) {
        return (PublicKeyIDWithPublicKey)this.keystoreCache.getPublicKeys().computeIfAbsent(forUser, id -> this.publicKeyList(forUser)).get(0);
    }

    private List<PublicKeyIDWithPublicKey> publicKeyList(UserID forUser) {
        List list;
        AbsoluteLocation accessiblePublicKey = this.bucketAccessService.publicAccessFor(forUser, (PublicResource)this.profiles.publicProfile(forUser).getPublicKeys().getResource());
        try (JsonReader is = new JsonReader((Reader)new InputStreamReader(this.readService.read(accessiblePublicKey)));){
            list = (List)this.serde.fromJson(is, new TypeToken<List<PublicKeyIDWithPublicKey>>(){}.getType());
        }
        return list;
    }
}

