/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import java.io.OutputStream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class ProfileStoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileStoreService.class);
    private final GsonSerde serde;
    private final UserProfileCache profileCache;
    private final DFSConfig dfsConfig;
    private final BucketAccessService access;
    private final StorageWriteService writeService;

    @Inject
    public ProfileStoreService(GsonSerde serde, UserProfileCache profileCache, DFSConfig dfsConfig, BucketAccessService access, StorageWriteService writeService) {
        this.serde = serde;
        this.profileCache = profileCache;
        this.dfsConfig = dfsConfig;
        this.access = access;
        this.writeService = writeService;
    }

    public void registerPrivate(UserID id, UserPrivateProfile profile) {
        log.debug("Register private {}", (Object)profile);
        try (OutputStream os = this.writeService.write(WithCallback.noCallback((Object)this.access.withSystemAccess(this.dfsConfig.privateProfile(id))));){
            os.write(this.serde.toJson(profile).getBytes());
        }
        this.profileCache.getPrivateProfile().remove(id);
    }

    public void registerPublic(UserID id, UserPublicProfile profile) {
        log.debug("Register public {}", (Object)profile);
        try (OutputStream os = this.writeService.write(WithCallback.noCallback((Object)this.access.withSystemAccess(this.dfsConfig.publicProfile(id))));){
            os.write(this.serde.toJson(profile).getBytes());
        }
        this.profileCache.getPublicProfile().remove(id);
    }
}

