/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.profile.keys.DocumentKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileUpdatingService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class ProfileUpdatingServiceImpl
implements ProfileUpdatingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileUpdatingServiceImpl.class);
    private final ProfileStoreService storeService;
    private final PrivateKeyService privateKeyService;
    private final StorageKeyStoreOperations storageKeyStoreOper;
    private final DocumentKeyStoreOperations keyStoreOper;

    @Inject
    public ProfileUpdatingServiceImpl(ProfileStoreService storeService, PrivateKeyService privateKeyService, StorageKeyStoreOperations storageKeyStoreOper, DocumentKeyStoreOperations keyStoreOper) {
        this.storeService = storeService;
        this.privateKeyService = privateKeyService;
        this.storageKeyStoreOper = storageKeyStoreOper;
        this.keyStoreOper = keyStoreOper;
    }

    public void updatePublicProfile(UserIDAuth forUser, UserPublicProfile profile) {
        this.validateKeystoreAccess(forUser);
        log.debug("Update public profile {}", (Object)profile);
        this.storeService.registerPublic(forUser.getUserID(), profile);
    }

    public void updatePrivateProfile(UserIDAuth forUser, UserPrivateProfile profile) {
        this.validateKeystoreAccess(forUser);
        log.debug("Update private profile {}", (Object)profile);
        this.storeService.registerPrivate(forUser.getUserID(), profile);
    }

    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        log.debug("Update read key for profile {}", (Object)forUser.getUserID());
        this.keyStoreOper.updateReadKeyPassword(forUser, newPassword);
        this.storageKeyStoreOper.updateReadKeyPassword(forUser, newPassword);
    }

    private void validateKeystoreAccess(UserIDAuth user) {
        this.privateKeyService.validateUserHasAccessOrThrow(user);
    }
}

